package ru.yandex.antifraud.util;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;

import javax.annotation.Nonnull;

import ru.yandex.json.writer.JsonWriterBase;

public enum QueryHelpers {
    INSTANCE;

    public void setMax(
            @Nonnull final JsonWriterBase writer,
            @Nonnull final String fieldName,
            long value)
            throws IOException {
        writer.key(fieldName);
        writer.startObject();
        {
            writer.key("max");
            writer.startArray();
            {
                get(writer, fieldName);
                writer.value(value);
            }
            writer.endArray();
        }
        writer.endObject();
    }

    public void smoothIncrement(
            @Nonnull final JsonWriterBase writer,
            @Nonnull final String fieldName,
            @Nonnull final String lastUpdateField,
            Instant now,
            Duration tau,
            long count)
            throws IOException {
        writer.key(fieldName);
        writer.startObject();
        {

            writer.key("sumf");
            writer.startArray();
            {
                writer.value(count);
                writer.startObject();
                {
                    writer.key("mulf");
                    writer.startArray();
                    {
                        get(writer, fieldName);
                        writer.startObject();
                        {
                            writer.key("minf");
                            writer.startArray();
                            {
                                writer.value(1);
                                writer.startObject();
                                {
                                    writer.key("maxf");
                                    writer.startArray();
                                    {
                                        writer.value(0);


                                        writer.startObject();
                                        {
                                            writer.key("powf");
                                            writer.startArray();
                                            {
                                                writer.value(Math.E);
                                                writer.startObject();
                                                {
                                                    writer.key("divf");
                                                    writer.startArray();
                                                    {
                                                        writer.startObject();
                                                        {
                                                            writer.key("sub");
                                                            writer.startArray();
                                                            {
                                                                writer.value(now.toEpochMilli());
                                                                get(writer, lastUpdateField);
                                                            }
                                                            writer.endArray();
                                                        }
                                                        writer.endObject();
                                                        writer.value(-tau.toMillis());
                                                    }
                                                    writer.endArray();
                                                }
                                                writer.endObject();
                                            }
                                            writer.endArray();
                                        }
                                        writer.endObject();
                                    }
                                    writer.endArray();
                                }
                                writer.endObject();
                            }
                            writer.endArray();
                        }
                        writer.endObject();
                    }
                    writer.endArray();
                }
                writer.endObject();
            }
            writer.endArray();
        }
        writer.endObject();
    }

    public void setOnCreate(
            @Nonnull final JsonWriterBase writer,
            @Nonnull final String field,
            final long value)
            throws IOException {
        writer.key(field);
        writer.startObject();
        {
            writer.key("default");
            writer.startArray();
            {
                writer.value(value);
            }
            writer.endArray();
        }
        writer.endObject();
    }

    public void get(@Nonnull final JsonWriterBase writer,
                    @Nonnull final String fieldName) throws IOException {
        writer.startObject();
        {
            writer.key("get");
            writer.startArray();
            writer.value(fieldName);
            writer.endArray();
        }
        writer.endObject();
    }
}
