package ru.yandex.antifraud.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

import javax.annotation.Nonnull;

public class Range<T> implements Predicate<T> {

    private final List<T> bounds;
    @Nonnull
    private final Comparator<T> comparator;

    public Range(@Nonnull Comparator<T> comparator) {
        this.bounds = new ArrayList<>();
        this.comparator = comparator;
    }

    public boolean isEmpty() {
        return bounds.isEmpty();
    }

    public void unionWith(@Nonnull final T b, @Nonnull final T e) {
        if (bounds.isEmpty()) {
            bounds.add(b);
            bounds.add(e);
        } else {
            int i = 0;
            for (; i < bounds.size(); i += 2) {
                final T currentBegin = bounds.get(i);
                if (comparator.compare(b, currentBegin) < 0) {
                    bounds.add(i, b);
                    bounds.add(i + 1, e);
                    break;
                }
            }
            if (i == bounds.size()) {
                bounds.add(b);
                bounds.add(e);
            }
            collapse();
        }
    }

    @Override
    public boolean test(T instant) {
        for (int i = 0; i < bounds.size(); i += 2) {
            if (comparator.compare(instant, bounds.get(i)) >= 0 && comparator.compare(instant, bounds.get(i + 1)) < 0) {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public List<T> bounds() {
        return bounds;
    }

    public void visitRanges(@Nonnull BiConsumer<T, T> consumer) {
        for (int i = 0; i < bounds.size(); i += 2) {
            consumer.accept(bounds.get(i), bounds.get(i + 1));
        }
    }

    void collapse() {
        for (int begin = 0; begin < bounds.size() - 2; begin += 2) {
            int end = begin + 1;
            for (int nextBegin = end + 1; nextBegin < bounds.size(); ) {
                if (comparator.compare(bounds.get(end), bounds.get(nextBegin)) >= 0) {
                    bounds.remove(nextBegin);

                    if (comparator.compare(bounds.get(end), bounds.get(nextBegin)) >= 0) {
                        bounds.remove(nextBegin);
                    } else {
                        bounds.remove(end);
                    }
                } else {
                    nextBegin += 2;
                }
            }
        }
    }
}
