package ru.yandex.antifraud.util;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Nonnull;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.CallbackFutureBase;

public class RunAllCallback<T> extends CallbackFutureBase<T, List<Runnable>> {
    @Nonnull
    private final Logger logger;

    public RunAllCallback(FutureCallback<T> callback, @Nonnull Logger logger) {
        super(callback);
        this.logger = logger;
    }

    @Override
    protected T convertResult(List<Runnable> result) {
        for (Runnable runnable : result) {
            if (runnable == null) {
                continue;
            }
            try {
                runnable.run();
            } catch (Exception e) {
                logger.log(Level.WARNING, "error on run callback", e);
            }
        }
        return null;
    }
}
