package ru.yandex.antifraud.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.util.timesource.TimeSource;

public class SessionCramps implements BreadCramps {
    @Nonnull
    private final LoggingServerConnection loggingServerConnection;

    public SessionCramps(@Nonnull LoggingServerConnection loggingServerConnection) {
        this.loggingServerConnection = loggingServerConnection;
    }

    public SessionCramps(@Nonnull ProxySession session) {
        this(session.connection());
    }

    @Override
    public void dropCramp(@Nonnull String name, @Nullable Object cramp) {
        if (cramp != null) {
            loggingServerConnection.setSessionInfo(name, cramp.toString());
        }
    }

    @Override
    public void dropTimestampCramp(@Nonnull String name) {
        dropCramp(name, TimeSource.INSTANCE.currentTimeMillis());
    }
}
