package ru.yandex.antifraud.util;

import java.time.Duration;
import java.time.Instant;

import javax.annotation.Nonnull;

public enum Shard {
    INSTANCE;

    private static final int OFFSET = 1000;
    private static final int MOD = 1000;

    private static final long MS_PER_DAY = Duration.ofDays(1).toMillis();

    public static long previous(long prefix) {
        return normalize(prefix - 1);
    }

    public static long normalize(long shard) {
        return calcByDays(shard - OFFSET);
    }

    public static long calcByDays(long daysSinceEpoch) {
        return OFFSET + ((MOD + (daysSinceEpoch % MOD)) % MOD);
    }

    public static long calcByTimestamp(@Nonnull Instant t) {
        return calcByDays(t.toEpochMilli() / MS_PER_DAY);
    }
}
