package ru.yandex.antifraud.util;

import java.util.function.Function;

import javax.annotation.Nonnull;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericBiConsumer;
import ru.yandex.function.GenericConsumer;

public class Waterfall<CB_ARG_TYPE, ARG_TYPE> {
    @Nonnull
    private final FutureCallback<CB_ARG_TYPE> cb;

    public static <T1> void waterfall(@Nonnull GenericConsumer<FutureCallback<T1>, ?> task1,
                                      @Nonnull FutureCallback<T1> fin) {
        new Waterfall<T1, Void>(fin)
                .<T1>before((cb, unused) -> task1.accept(cb))
                .start();
    }

    public static <T2, T1> void waterfall(@Nonnull GenericConsumer<FutureCallback<T2>, ?> task1,
                                          @Nonnull GenericBiConsumer<FutureCallback<T1>, T2, ?> task2,
                                          @Nonnull FutureCallback<T1> fin) {
        new Waterfall<T1, T2>(fin)
                .<Void>before(task2)
                .<T1>before((cb, unused) -> task1.accept(cb))
                .start();
    }

    public static <T3, T2, T1> void waterfall(@Nonnull GenericConsumer<FutureCallback<T3>, ?> task1,
                                              @Nonnull GenericBiConsumer<FutureCallback<T2>, T3, ?> task2,
                                              @Nonnull GenericBiConsumer<FutureCallback<T1>, T2, ?> task3,
                                              @Nonnull FutureCallback<T1> fin) {
        new Waterfall<T1, T2>(fin)
                .<T3>before(task3)
                .<Void>before(task2)
                .<T1>before((cb, unused) -> task1.accept(cb))
                .start();
    }

    public static <T4, T3, T2, T1> void waterfall(@Nonnull GenericConsumer<FutureCallback<T4>, ?> task1,
                                                  @Nonnull GenericBiConsumer<FutureCallback<T3>, T4, ?> task2,
                                                  @Nonnull GenericBiConsumer<FutureCallback<T2>, T3, ?> task3,
                                                  @Nonnull GenericBiConsumer<FutureCallback<T1>, T2, ?> task4,
                                                  @Nonnull FutureCallback<T1> fin) {
        new Waterfall<T1, T2>(fin)
                .<T3>before(task4)
                .<T4>before(task3)
                .<Void>before(task2)
                .<T1>before((cb, unused) -> task1.accept(cb))
                .start();
    }

    public static <T5, T4, T3, T2, T1> void waterfall(@Nonnull GenericConsumer<FutureCallback<T5>, ?> task1,
                                                      @Nonnull GenericBiConsumer<FutureCallback<T4>, T5, ?> task2,
                                                      @Nonnull GenericBiConsumer<FutureCallback<T3>, T4, ?> task3,
                                                      @Nonnull GenericBiConsumer<FutureCallback<T2>, T3, ?> task4,
                                                      @Nonnull GenericBiConsumer<FutureCallback<T1>, T2, ?> task5,
                                                      @Nonnull FutureCallback<T1> fin) {
        new Waterfall<T1, T2>(fin)
                .<T3>before(task5)
                .<T4>before(task4)
                .<T5>before(task3)
                .<Void>before(task2)
                .<T1>before((cb, unused) -> task1.accept(cb))
                .start();
    }

    public static <T6, T5, T4, T3, T2, T1> void waterfall(@Nonnull GenericConsumer<FutureCallback<T6>, ?> task1,
                                                          @Nonnull GenericBiConsumer<FutureCallback<T5>, T6, ?> task2,
                                                          @Nonnull GenericBiConsumer<FutureCallback<T4>, T5, ?> task3,
                                                          @Nonnull GenericBiConsumer<FutureCallback<T3>, T4, ?> task4,
                                                          @Nonnull GenericBiConsumer<FutureCallback<T2>, T3, ?> task5,
                                                          @Nonnull GenericBiConsumer<FutureCallback<T1>, T2, ?> task6,
                                                          @Nonnull FutureCallback<T1> fin) {
        new Waterfall<T1, T2>(fin)
                .<T3>before(task6)
                .<T4>before(task5)
                .<T5>before(task4)
                .<T6>before(task3)
                .<Void>before(task2)
                .<T1>before((cb, unused) -> task1.accept(cb))
                .start();
    }

    private Waterfall(@Nonnull FutureCallback<CB_ARG_TYPE> cb) {
        this.cb = cb;
    }

    private <BEFORE_ARG_TYPE> Waterfall<ARG_TYPE, BEFORE_ARG_TYPE> before(
            GenericBiConsumer<FutureCallback<CB_ARG_TYPE>, ARG_TYPE, ?> before,
            Function<FutureCallback<ARG_TYPE>, FutureCallback<ARG_TYPE>> cbTransformer) {
        return new Waterfall<>(cbTransformer.apply(new Callback<>(cb, before)));
    }

    private <BEFORE_ARG_TYPE> Waterfall<ARG_TYPE, BEFORE_ARG_TYPE> before(
            GenericBiConsumer<FutureCallback<CB_ARG_TYPE>, ARG_TYPE, ?> before) {
        return before(before, (cb) -> cb);
    }

    private void start() {
        cb.completed(null);
    }

    class Callback<BEFORE_ARG_TYPE> implements FutureCallback<ARG_TYPE> {
        @Nonnull
        private final FutureCallback<BEFORE_ARG_TYPE> cb;
        @Nonnull
        private final GenericBiConsumer<FutureCallback<BEFORE_ARG_TYPE>, ARG_TYPE, ?> stage;

        Callback(@Nonnull FutureCallback<BEFORE_ARG_TYPE> cb,
                 @Nonnull GenericBiConsumer<FutureCallback<BEFORE_ARG_TYPE>, ARG_TYPE, ?> stage) {
            this.cb = cb;
            this.stage = stage;
        }

        @Override
        public void completed(ARG_TYPE t) {
            try {
                stage.accept(cb, t);
            } catch (Exception e) {
                failed(e);
            }
        }

        @Override
        public void failed(Exception e) {
            cb.failed(e);
        }

        @Override
        public void cancelled() {
            cb.cancelled();
        }
    }
}
