package ru.yandex.antifraud.yt;

import java.util.List;

import javax.annotation.Nonnull;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.antifraud.data.ListItem;
import ru.yandex.antifraud.storage.ListItemSearchRequest;
import ru.yandex.antifraud.yt.config.ImmutableYtClientConfig;
import ru.yandex.yt.ytclient.bus.DefaultBusConnector;
import ru.yandex.yt.ytclient.proxy.LookupRowsRequest;
import ru.yandex.yt.ytclient.proxy.YtClient;
import ru.yandex.yt.ytclient.rpc.RpcCredentials;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;

@SuppressWarnings("UnusedVariable")
public class YtListsClient {
    private static final TableSchema SCHEMA = new TableSchema.Builder()
            .addKey("list_name", ColumnValueType.STRING)
            .addKey("value", ColumnValueType.STRING)
            .addValue("meta", ColumnValueType.ANY)
            .addValue("since", ColumnValueType.UINT64)
            .addValue("until", ColumnValueType.UINT64)
            .build();
    private static final TableSchema LOOKUP_SCHEMA = SCHEMA.toLookup();
    private static final TableSchema WRITE_SCHEMA = SCHEMA.toWrite();

    @Nonnull
    private final ImmutableYtClientConfig config;

    @Nonnull
    private final YtClient client;

    public YtListsClient(@Nonnull ImmutableYtClientConfig config) {
        final DefaultBusConnector bus = new DefaultBusConnector();
        this.config = config;
        client = new YtClient(bus, config.proxy(), new RpcCredentials(config.login(), config.token()));
    }

    void search(@Nonnull List<ListItemSearchRequest> listItemSearchRequests,
                @Nonnull FutureCallback<List<ListItem>> callback) {
        final LookupRowsRequest request = new LookupRowsRequest(config.table(), LOOKUP_SCHEMA)
                .addLookupColumns("meta", "since", "until");
//
//        for(ListItemSearchRequest listItemSearchRequest : listItemSearchRequests) {
//            request.addFilter(listItemSearchRequest.listName(), listItemSearchRequest.value());
//        }
//
//        final CompletableFuture<UnversionedRowset> future = client.lookupRows(request);
//
//        future.handle((rows, error) -> {
//            if(error != null) {
//                callback.failed(new RuntimeException(error));
//            }
//
//            final List<YTreeMapNode> nodes = rows.getYTreeRows();
//
//            if(nodes.isEmpty()) {
//                callback.completed(Collections.emptyList());
//            }
//
//            final List<ListItem> items = new ArrayList<>(nodes.size());
//
//            for(YTreeMapNode node : nodes) {
//                 items.add(new ListItem())
//            }
//
//            callback.completed(items);
//        });
    }
}
