package ru.yandex.antifraud.yt.config;

import javax.annotation.Nonnull;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractYtClientConfigBuilder
        <T extends AbstractYtClientConfigBuilder<T>>
        implements YtClientConfig {
    @Nonnull
    private String login;

    @Nonnull
    private String token;

    @Nonnull
    private String proxy;

    @Nonnull
    private String table;

    protected AbstractYtClientConfigBuilder(final YtClientConfig config) {
        login = config.login();
        token = config.token();
        proxy = config.proxy();
        table = config.table();
    }

    protected AbstractYtClientConfigBuilder(
            final IniConfig config,
            final YtClientConfig defaults) throws ConfigException {
        login = config.getString("login");
        token = config.getString("token");
        proxy = config.getString("proxy", defaults.proxy());
        table = config.getString("table");
    }

    @Override
    @Nonnull
    public String login() {
        return login;
    }

    public void login(@Nonnull String login) {
        this.login = login;
    }

    @Override
    @Nonnull
    public String token() {
        return token;
    }

    public void token(@Nonnull String token) {
        this.token = token;
    }

    @Override
    @Nonnull
    public String proxy() {
        return proxy;
    }

    public void proxy(@Nonnull String proxy) {
        this.proxy = proxy;
    }

    @Override
    @Nonnull
    public String table() {
        return table;
    }

    public void table(@Nonnull String table) {
        this.table = table;
    }
}

