package ru.yandex.antifraud.yt.config;

import javax.annotation.Nonnull;

public class ImmutableYtClientConfig
        implements YtClientConfig {
    @Nonnull
    private final String login;

    @Nonnull
    private final String token;

    @Nonnull
    private final String proxy;

    @Nonnull
    private final String table;

    public ImmutableYtClientConfig(final YtClientConfig config) {
        login = config.login();
        token = config.token();
        proxy = config.proxy();
        table = config.table();
    }

    @Nonnull
    @Override
    public String login() {
        return login;
    }

    @Nonnull
    @Override
    public String token() {
        return token;
    }

    @Nonnull
    @Override
    public String proxy() {
        return proxy;
    }

    @Nonnull
    @Override
    public String table() {
        return table;
    }
}

