package ru.yandex.antifraud.yt.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class YtClientConfigBuilder
        extends AbstractYtClientConfigBuilder<YtClientConfigBuilder> {
    public YtClientConfigBuilder() {
        super(YtClientConfigDefaults.INSTANCE);
    }

    public YtClientConfigBuilder(final YtClientConfig config) {
        super(config);
    }

    public YtClientConfigBuilder(final IniConfig config)
            throws ConfigException {
        super(config, YtClientConfigDefaults.INSTANCE);
    }

    public YtClientConfigBuilder(
            final IniConfig config,
            final YtClientConfig defaults)
            throws ConfigException {
        super(config, defaults);
    }

    public ImmutableYtClientConfig build() throws ConfigException {
        return new ImmutableYtClientConfig(this);
    }
}

