JAVA_LIBRARY()

JDK_VERSION(11)

OWNER(g:so)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/stricter_java_check.inc)

JAVA_SRCS(SRCDIR main/java **/*.java)

PEERDIR(
    mail/so/libs/java/lua_utils
    mail/library/json/json_dom
    mail/library/http/stater
    mail/library/logger
    mail/util/config_parser
    mail/util/jni_catboost
    mail/util/jni_hypocrisy
    mail/util/ip_utils
    mail/library/blackbox
    passport/infra/daemons/ysa/fingerprint
    metrika/uatraits/java
    library/java/monlib/metrics
    mail/so/libs/java/so_factors
    yt/java/ytclient
    contrib/java/com/googlecode/libphonenumber/libphonenumber
)

SET(excluded_netty_version 4.1.42.Final)
EXCLUDE(
    contrib/java/io/netty/netty-resolver/${excluded_netty_version}
    contrib/java/io/netty/netty-handler/${excluded_netty_version}
    contrib/java/io/netty/netty-codec/${excluded_netty_version}
    contrib/java/io/netty/netty-buffer/${excluded_netty_version}
    contrib/java/io/netty/netty-transport/${excluded_netty_version}
)

END()

IF(SANITIZER_TYPE != "memory" AND SANITIZER_TYPE != "undefined")
    RECURSE_FOR_TESTS(
        test
    )

    IF(CHECK_RULES)
        RECURSE_FOR_TESTS(
            test_encrypted
        )
    ENDIF()
ENDIF()
