package ru.yandex.antifraud_runner;

import ru.yandex.antifraud.channel.ExecutionContext;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.OperationContext;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.operations.map.Mapper;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.writer.DollarJsonWriter;
import ru.yandex.json.writer.JsonWriter;

public class AggregatorMapper implements Mapper<YTreeMapNode, YTreeMapNode> {

    @Override
    public void map(YTreeMapNode inputRow, Yield<YTreeMapNode> yield, Statistics statistics, OperationContext context) {
        final LogAggregator logAggregator = new LogAggregator(request -> {
            StringBuilderWriter sb = new StringBuilderWriter();
            try (JsonWriter w = new DollarJsonWriter(sb)) {
                w.value(request.asDebugJson());
            }

            yield.yield(
                    YnodeUtils.json2ynode(TypesafeValueContentHandler.parse(sb.toString()), YTree.builder()).build().mapNode());
        });

        try {
            final JsonObject src = YnodeUtils.ynode2json(inputRow, BasicContainerFactory.INSTANCE);
            logAggregator.accept(new ExecutionContext(src.asMap()));

            logAggregator.finish();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

