package ru.yandex.antifraud_runner;

import java.util.Iterator;
import java.util.List;

import javax.annotation.Nonnull;

import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.writer.JsonType;
import ru.yandex.lua.util.JsonUtils;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class RowsMergerReducer implements ReducerWithKey<YTreeMapNode, YTreeMapNode, String> {
    public static final String REDUCED_BY_FIELD = "id";

    private final int maxNestedContainerSize;

    @Nonnull
    private final List<String> fieldsToMerge;

    public RowsMergerReducer(int maxNestedContainerSize, @Nonnull List<String> fieldsToMerge) {
        this.maxNestedContainerSize = maxNestedContainerSize;
        this.fieldsToMerge = fieldsToMerge;
    }

    @Override
    public void reduce(String key, Iterator<YTreeMapNode> input, Yield<YTreeMapNode> yield, Statistics statistics) {
        try {
            JsonMap result = YnodeUtils.ynode2json(input.next(), BasicContainerFactory.INSTANCE).asMap();
            while (input.hasNext()) {
                final JsonMap next = YnodeUtils.ynode2json(input.next(), result.containerFactory()).asMap();
                for (String field : fieldsToMerge) {
                    final JsonMap dst = result.getMapOrNull(field);
                    final JsonMap src = next.getMapOrNull(field);

                    if (src == null) {
                        continue;
                    }

                    if (dst == null) {
                        result.put(field, src);
                    } else {
                        JsonUtils.merge(dst, src);
                    }
                }
            }

            result = JsonUtils.truncate(result, maxNestedContainerSize);

            for (var entry : result.entrySet()) {
                final String k = entry.getKey();
                final JsonObject v = entry.getValue();
                switch (v.type()) {
                    case LIST:
                    case MAP:
                        result.put(k, new JsonString(JsonType.DOLLAR.toString(v)));
                        break;
                    default:
                        break;
                }
            }

            yield.yield(
                    YnodeUtils.json2ynode(result, YTree.builder()).build().mapNode());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String key(YTreeMapNode entry) {
        return entry.getString(REDUCED_BY_FIELD);
    }
}
