package ru.yandex.antifraud_runner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;

import com.google.errorprone.annotations.MustBeClosed;
import sun.misc.Unsafe;

import ru.yandex.antifraud.channel.ExecutionContext;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;

public class Runner {
    public static void main(String[] args) throws Throwable {
        disableWarning();

        final URI pathToData = URI.create(args[0]);
        final URI pathToResults = URI.create(args[1]);
        final Runner runner = new Runner();

        try (final Stream<String> input = getInputStream(pathToData);
             final BufferedWriter output = getOutput(pathToResults)) {
            final var consumer = runner.makeConsumer(output);

            try {
                runner.processSafe(input, consumer);
            } finally {
                consumer.finish();
            }
        }
    }

    public static void disableWarning() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe u = (Unsafe) theUnsafe.get(null);

            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = cls.getDeclaredField("logger");
            u.putObjectVolatile(cls, u.staticFieldOffset(logger), null);
        } catch (Exception e) {
            // ignore
        }
    }

    @MustBeClosed
    public static Stream<String> getInputStream(URI uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return Files.lines(Path.of(uri), Charset.defaultCharset());
        } else if ("std".equals(uri.getScheme())) {
            // note: it is possible to set stdin as file:///dev/fd/0
            return new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())).lines();
        } else {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " is not supported");
        }
        // TODO add yt://
    }

    private static BufferedWriter getOutput(URI uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return new BufferedWriter(new FileWriter(Path.of(uri).toFile(), Charset.defaultCharset()));
        } else if ("std".equals(uri.getScheme())) {
            return new BufferedWriter(new OutputStreamWriter(System.out, Charset.defaultCharset()));
        } else {
            throw new IllegalArgumentException("Scheme " + uri.getScheme() + " is not supported");
        }
        // TODO add yt://
    }

    public LogItemConsumer<?> makeConsumer(Writer output) {
        return new LogAggregator(request -> {
            try (JsonWriter w = new JsonWriter(output)) {
                w.value(request.asDebugJson());
            }
            output.write('\n');
        });
    }

    public <E extends Throwable> void processSafe(Stream<String> input, LogItemConsumer<E> consumer) throws E,
            JsonException {
        for (Iterator<String> it = input.iterator(); it.hasNext(); ) {
            consumer.accept(new ExecutionContext(TypesafeValueContentHandler.parse(it.next()).asMap()));
        }
    }
}
