package ru.yandex.antifraud_runner;

import javax.annotation.Nonnull;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonDouble;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.JsonException;

public class YnodeUtils {
    @Nonnull
    public static JsonObject ynode2json(@Nonnull YTreeNode node, @Nonnull ContainerFactory containerFactory) throws JsonException {
        if (node.isMapNode()) {
            final var src = node.asMap();
            final JsonMap dst = new JsonMap(containerFactory, src.size());
            for (var entry : src.entrySet()) {
                dst.put(entry.getKey(), ynode2json(entry.getValue(), containerFactory));
            }
            return dst;
        } else if (node.isListNode()) {
            final var src = node.asList();
            final JsonList dst = new JsonList(containerFactory, src.size());
            for (var entry : src) {
                dst.add(ynode2json(entry, containerFactory));
            }
            return dst;
        } else if (node.isStringNode()) {
            return new JsonString(node.stringValue());
        } else if (node.isIntegerNode()) {
            return JsonLong.valueOf(node.longValue());
        } else if (node.isDoubleNode()) {
            return new JsonDouble(node.doubleValue());
        } else if (node.isBooleanNode()) {
            return JsonBoolean.valueOf(node.boolValue());
        } else if (node.isEntityNode()) {
            return JsonNull.INSTANCE;
        } else {
            throw new JsonException("unknown node type " + node);
        }
    }

    @Nonnull
    public static YTreeBuilder json2ynode(@Nonnull JsonObject json, @Nonnull YTreeBuilder builder) throws JsonException {
        switch (json.type()) {
            case NULL:
                return builder.entity();
            case BOOLEAN:
                return builder.value(json.asBoolean());
            case LONG:
                return builder.value(json.asLong());
            case DOUBLE:
                return builder.value(json.asDouble());
            case STRING:
                return builder.value(json.asString());
            case LIST:
                builder = builder.beginList();
                for (var v : json.asList()) {
                    builder = json2ynode(v, builder);
                }
                return builder.endList();
            case MAP:
                builder = builder.beginMap();
                for (var v : json.asMap().entrySet()) {
                    builder = json2ynode(v.getValue(), builder.key(v.getKey()));
                }
                return builder.endMap();
        }

        throw new JsonException("unexpeected type:" + json.type() + ':' + json);
    }
}
