package ru.yandex.antifraud_runner;

import java.util.Arrays;

import ru.yandex.antifraud.storage.CollapsedAggregatesUpdateRequest;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.RichYPath;
import ru.yandex.inside.yt.kosher.impl.YtUtils;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.inside.yt.kosher.operations.specs.MapReduceSpec;
import ru.yandex.inside.yt.kosher.operations.specs.MapperSpec;
import ru.yandex.inside.yt.kosher.operations.specs.ReducerSpec;

public class YtMain {
    public static void main(String[] args) {
        final String proxy = args[0];
        final String token = args[1];
        final String src = args[2];
        final String dst = args[3];
        final int maxNestedContainerSize = Integer.parseInt(args[4]);

        final Yt yt = YtUtils.http(proxy, token);

        final Operation operation = yt.operations().mapReduceAndGetOp(
                MapReduceSpec.builder()
                        .addInputTable(RichYPath.simple(src))
                        .addOutputTable(RichYPath.simple(dst))
                        .setMapperSpec(MapperSpec.builder()
                                .setMapper(new AggregatorMapper())
                                .build())
                        .setReducerSpec(ReducerSpec.builder()
                                .setReducer(new RowsMergerReducer(
                                        maxNestedContainerSize,
                                        Arrays.asList(
                                                CollapsedAggregatesUpdateRequest.STRUCTURED_AGGRS_FIELD,
                                                CollapsedAggregatesUpdateRequest.AGGRS_FIELD)))
                                .build())
                        .setReduceBy(RowsMergerReducer.REDUCED_BY_FIELD)
                        .build());
        operation.awaitAndThrowIfNotSuccess();
    }
}
