
#include <library/cpp/yson/node/node.h>
#include <mapreduce/yt/interface/operation.h>
#include <mapreduce/yt/interface/init.h>
#include <mapreduce/yt/interface/client.h>

#include <library/cpp/getopt/last_getopt.h>

#include <util/folder/path.h>
#include <util/generic/hash_set.h>
#include <util/string/join.h>

class TMapper : public NYT::IMapper<NYT::TTableReader<NYT::TNode>, NYT::TTableWriter<NYT::TNode>> {
public:
    void Do(NYT::TTableReader<NYT::TNode> *input, NYT::TTableWriter<NYT::TNode> *output) override {
        for (; input->IsValid(); input->Next()) {
            output->AddRow(input->MoveRow());
        }
    }

    void PrepareOperation(const NYT::IOperationPreparationContext &context,
                          NYT::TJobOperationPreparer &preparer) const override {
        const auto &schema = context.GetInputSchema(/* tableIndex */ 0);
        preparer.OutputSchema(/* tableIndex */ 0, schema);
    }

    TMapper() = default;
};

REGISTER_MAPPER(TMapper)

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);

    NYT::TYPath srcDir;
    NYT::TYPath dstTable;
    {
        NLastGetopt::TOpts opts;
        opts.AddLongOption("src", "dir for collapse").StoreResult(&srcDir).Required();
        opts.AddLongOption("dst", "dst table with collapsed logs").StoreResult(&dstTable).Required();
        NLastGetopt::TOptsParseResult parsedOpts(&opts, argc, argv);
        while (srcDir && srcDir.back() == '/') {
            srcDir.pop_back();
        }
    }

    const auto client = NYT::CreateClientFromEnv();

    const auto transaction = client->StartTransaction();
    {
        NYT::TMapOperationSpec spec;
        for(const NYT::TNode& node : transaction->List(srcDir,
                                                       NYT::TListOptions()
                                                       .AttributeFilter(
                                                               NYT::TAttributeFilter()
                                                               .AddAttribute("type")
                                                       ))) {
            if(node.GetAttributes().AsMap().at("type").AsString() == "table") {
                spec.AddInput<NYT::TNode>(srcDir + '/' + node.AsString());
                Cout << spec.Inputs_.back().Path_ << Endl;
            }
        }
        spec.AddOutput<NYT::TNode>(dstTable);

        transaction->Map(spec, new TMapper());

        for(const NYT::TRichYPath& src : spec.Inputs_) {
            transaction->Remove(src.Path_);
        }
    }
    transaction->Commit();

    return 0;
}
