--[[creating new features:
add comparing region from phone number and region from ip,
compare region from ip and information fron possible language from fingerprint,
create features with login processing]]

local uatraits = require('uatraits');
local luajava = require('luajava');
local util = require('util');
local libphonenumber = require('libphonenumber');


local Instant = luajava.bindClass("java.time.Instant");
local LocalDateTime = luajava.bindClass("java.time.LocalDateTime");
local ZoneId = luajava.bindClass("java.time.ZoneId");


local function setContains(set, key)
    return set[key] ~= nil
end

local function entropy(X)
    local N, count, sum, i = X:len(), {}, 0
    for char = 1, N do
        i = X:sub(char, char)
        if count[i] then
            count[i] = count[i] + 1
        else
            count[i] = 1
        end
    end
    for n_i, count_i in pairs(count) do
        sum = sum + count_i / N * math.log(count_i / N)
    end
    return math.floor(-sum * 10000)
end

local function process_num_features(feature)
    if feature == "" or feature == nil then
        return 0
    else
        return tonumber(feature)
    end
end

local function big_small_part(list_of_strings)
    local first_part, second_part;

    if #(list_of_strings) == 0 then
        return "", ""
    end

    if #(list_of_strings) == 1 then
        return list_of_strings[1], ""
    end

    first_part = table.remove(list_of_strings, 1)
    second_part = list_of_strings
    second_part = table.concat(second_part, "")
    if #(first_part) >= #(second_part) then
        return first_part, second_part
    else
        return second_part, first_part
    end
end

local vowel_upper_set = { A = true, E = true, I = true, O = true, U = true }
local vowel_lower_set = { a = true, e = true, i = true, o = true, u = true }
local digits_set = { ["0"] = true, ["1"] = true, ["2"] = true, ["3"] = true, ["4"] = true, ["5"] = true, ["6"] = true,
    ["7"] = true, ["8"] = true, ["9"] = true }
local consonant_upper_set = { B = true, C = true, D = true, F = true, G = true, H = true, J = true, K = true, L = true,
    M = true, N = true, P = true, Q = true, R = true, S = true, T = true, V = true, W = true, X = true, Y = true,
    Z = true }
local consonant_lower_set = { b = true, c = true, d = true, f = true, g = true, h = true, j = true, k = true, l = true,
    m = true, n = true, p = true, q = true, r = true, s = true, t = true, v = true, w = true, x = true, y = true,
    z = true }


local function login_processing(login)

    local vowels, consonant, digits, consonant_digits, lower, upper, symbols, res_order_vowels, res_order_consonants, res_order_digits, res_order_consonant_digits, ratio_uppercase_length, ratio_consonants_length, ratio_vowels_length, ratio_digits_length, ratio_consonant_digits_length = 0
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0;
    local max_order_digits, max_order_vowels, max_order_consonants, max_order_consonant_digits = 0, 0, 0, 0;

    local lenght = #(login)

    local dict_login_processing = {
        vowels = -1,
        consonant = -1,
        digits = -1,
        consonant_digits = -1,
        upper = -1,
        symbols = -1,
        lenght = -1,
        res_order_vowels = -1,
        res_order_consonants = -1,
        res_order_digits = -1,
        res_order_consonant_digits = -1,
        ratio_uppercase_length = -1,
        ratio_consonants_length = -1,
        ratio_vowels_length = -1,
        ratio_digits_length = -1,
        ratio_consonant_digits_length = -1
    }

    if lenght == 0 then
        return dict_login_processing
    end

    for ind_symb = 1, lenght do
        local symb = login:sub(ind_symb, ind_symb)

        if setContains(digits_set, symb) then
            max_order_consonant_digits = max_order_consonant_digits + 1
            max_order_digits = max_order_digits + 1
            res_order_digits = math.max(res_order_digits, max_order_digits)
            res_order_consonant_digits = math.max(res_order_consonant_digits, max_order_consonant_digits)
            digits = digits + 1
            consonant_digits = consonant_digits + 1
            max_order_consonants = 0
            max_order_vowels = 0

        elseif setContains(vowel_upper_set, symb) then
            upper = upper + 1
            vowels = vowels + 1
            max_order_vowels = max_order_vowels + 1
            res_order_vowels = math.max(res_order_vowels, max_order_vowels)
            max_order_digits = 0
            max_order_consonant_digits = 0
            max_order_consonants = 0


        elseif setContains(vowel_lower_set, symb) then
            lower = lower + 1
            vowels = vowels + 1
            max_order_vowels = max_order_vowels + 1
            res_order_vowels = math.max(res_order_vowels, max_order_vowels)
            max_order_digits = 0
            max_order_consonant_digits = 0
            max_order_consonants = 0

        elseif setContains(consonant_upper_set, symb) then
            max_order_consonant_digits = max_order_consonant_digits + 1
            max_order_consonants = max_order_consonants + 1

            res_order_consonants = math.max(res_order_consonants, max_order_consonants)
            res_order_consonant_digits = math.max(res_order_consonant_digits, max_order_consonant_digits)
            consonant = consonant + 1
            consonant_digits = consonant_digits + 1
            max_order_vowels = 0
            max_order_digits = 0
            upper = upper + 1

        elseif setContains(consonant_lower_set, symb) then
            max_order_consonant_digits = max_order_consonant_digits + 1
            max_order_consonants = max_order_consonants + 1
            res_order_consonants = math.max(res_order_consonants, max_order_consonants)
            res_order_consonant_digits = math.max(res_order_consonant_digits, max_order_consonant_digits)
            consonant = consonant + 1
            consonant_digits = consonant_digits + 1
            max_order_vowels = 0
            max_order_digits = 0
            lower = lower + 1

        else
            res_order_consonants = math.max(res_order_consonants, max_order_consonants)
            res_order_consonant_digits = math.max(res_order_consonant_digits, max_order_consonant_digits)
            max_order_vowels = 0
            max_order_digits = 0
            max_order_consonant_digits = 0
            max_order_consonants = 0
            max_order_vowels = 0
            max_order_digits = 0
            symbols = symbols + 1
        end
    end

    ratio_uppercase_length = upper / lenght
    ratio_consonants_length = consonant / lenght
    ratio_vowels_length = vowels / lenght
    ratio_digits_length = digits / lenght
    ratio_consonant_digits_length = consonant_digits / lenght




    dict_login_processing["vowels"] = vowels
    dict_login_processing["consonant"] = consonant
    dict_login_processing["digits"] = digits
    dict_login_processing["consonant_digits"] = consonant_digits
    dict_login_processing["upper"] = upper
    dict_login_processing["symbols"] = symbols
    dict_login_processing["lenght"] = lenght
    dict_login_processing["res_order_vowels"] = res_order_vowels
    dict_login_processing["res_order_consonants"] = res_order_consonants
    dict_login_processing["res_order_digits"] = res_order_digits
    dict_login_processing["res_order_consonant_digits"] = res_order_consonant_digits
    dict_login_processing["ratio_uppercase_length"] = ratio_uppercase_length
    dict_login_processing["ratio_consonants_length"] = ratio_consonants_length
    dict_login_processing["ratio_vowels_length"] = ratio_vowels_length
    dict_login_processing["ratio_digits_length"] = ratio_digits_length
    dict_login_processing["ratio_consonant_digits_length"] = ratio_consonant_digits_length


    return dict_login_processing

end

local module = {}

function module.make_features(context)
    local aggregates = context.aggrs;
    local request_data = context.src;
    local bb = context.raw_bb;
    local rbl = context.rbl;

    -- entropy calculation
    local entropy_login = 0;
    local entropy_big_login_part = 0;
    local entropy_small_login_part = 0;
    local cat_features = {};
    local num_features = {};
    local with_phones = -1;
    local country_from_bb = "";
    local email = "";
    local login = "";
    local phone_number = "";

    -- bb section (login and phone)

    if bb then
        with_phones = (next(bb.phones) == nil and 0) or 1;
        country_from_bb = bb.attributes["31"] or "";
        login = bb.login;
        email = bb.aliases["5"] or "";
        local big_login_part = bb.big_login_part;
        local small_login_part = bb.small_login_part;
        local splitted_login;

        if string.find(login, "-", 1, true) then
            splitted_login = util.split(login, "-")
        elseif string.find(login, "@", 1, true) then
            splitted_login = util.split(login, "@")

        elseif string.find(login, ".", 1, true) then
            splitted_login = util.split(login, ".")
        else
            splitted_login = util.split(login, ".")
        end
        big_login_part, small_login_part = big_small_part(splitted_login);
        entropy_login = entropy(login);
        entropy_big_login_part = entropy(big_login_part);
        entropy_small_login_part = entropy(small_login_part);

        if bb.phones[1] then
            phone_number = bb.phones[1].attributes["104"]
        end


    end

    -- ip section
    local country_id = "";
    local region_id = "";
    local city_id = "";
    local provider = "";
    local asset = "";

    local is_hosting = -1;
    local is_tor = -1;
    local is_yandex_net = -1;
    local is_yandex_turbo = -1;
    local is_vpn = -1;
    local org_name = "";
    local isp_name = "";
    local tzname_rbl = "";
    local is_proxy = -1;
    local iso_name_rbl = "";
    if rbl then
        local geobase = context.rbl.infos.geobase;
        local region_info = geobase.region_info;
        local asn_list = geobase.ip_traits.asn_list or {};

        -- network part
        is_hosting = (geobase.ip_traits.is_hosting == "true" and 1) or 0;
        is_tor = (geobase.ip_traits.is_tor == "true" and 1) or 0;
        is_yandex_net = (geobase.ip_traits.is_yandex_net == "true" and 1) or 0;
        is_yandex_turbo = (geobase.ip_traits.is_yandex_turbo == "true" and 1) or 0;
        is_vpn = (geobase.ip_traits.is_vpn == "true" and 1) or 0;
        org_name = geobase.ip_traits.org_name or "";
        isp_name = geobase.ip_traits.isp_name or "";
        is_proxy = (geobase.ip_traits.is_proxy == "true" and 1) or 0;

        -- region part
        country_id = region_info.country_id or "";
        region_id = region_info.id or "";
        city_id = region_info.city_id or "";
        provider = geobase.ip_traits.org_name or "";
        asset = asn_list[1] or "";
        tzname_rbl = region_info.tzname or "";
        iso_name_rbl = region_info.iso_name or "";
    end

    -- time section change to local time
    local tmz = request_data.v2_account_timezone or "Europe/London";

    if tmz == "" then
        tmz = "Europe/London"
    end;
    
    local now = LocalDateTime:ofInstant(Instant:ofEpochMilli(request_data.t), ZoneId:of(tmz)) or
        LocalDateTime:ofInstant(Instant:ofEpochMilli(request_data.t), ZoneId:of("Europe/London"));

    local day_part = math.fmod(now:getHour(), 6);
    local hour = now:getHour();

    -- user_agent section
    local is_mobile = 0;
    local browser_name = "Unknown";
    local browser_version = "";
    local os_family = "Unknown";
    local os_version = "";

    if request_data.user_agent then
        local parts = uatraits.parse(request_data.user_agent);

        is_mobile = (parts.isMobile == "true" and 1) or 0;
        browser_name = parts.BrowserName or "Unknown";
        browser_version = parts.BrowserVersion or "";
        os_family = parts.OSFamily or "Unknown";
        os_version = parts.OSVersion or "";

    end

    -- passwd && passwdex section
    local passwd = { "0", "0", "0", "0" };
    if request_data.passwd then
        passwd = util.split(request_data.passwd, ".")
    end
    local passwdex = { "0", "0", "0", "0" };
    if request_data.passwdex then
        passwdex = util.split(request_data.passwdex, ".")
    end

    --diff part
    local diff_country_from_rbl_from_bb = -1;

    if iso_name_rbl == "" or country_from_bb == "" then
        diff_country_from_rbl_from_bb = -1
    elseif string.lower(iso_name_rbl) == country_from_bb then
        diff_country_from_rbl_from_bb = 1
    else diff_country_from_rbl_from_bb = 0
    end

    local diff_email_login = -1;

    if login == "" or email == "" then
        diff_email_login = -1
    elseif login == email then
        diff_email_login = 1
    else diff_email_login = 0
    end

    local domen = "";
    if email ~= "" then
        domen = util.split(email, "@")[2]
    --elseif src.email and src.email and src.email ~= nil and src.email ~= "" then 
    --    domen = util.split(src.email, "@")[2]
    else domen = ""
    end


    local diff_lang_fpt_lamg_ip = -1;
    local v2_accept_language = request_data.v2_accept_language or "";

    if iso_name_rbl == "" or v2_accept_language == "" then
        diff_lang_fpt_lamg_ip = -1
    elseif string.find(v2_accept_language, iso_name_rbl) then
        diff_lang_fpt_lamg_ip = 1
    else diff_lang_fpt_lamg_ip = 0
    end


    local dict_login_processing = {
        vowels = -1,
        consonant = -1,
        digits = -1,
        consonant_digits = -1,
        upper = -1,
        symbols = -1,
        lenght = -1,
        res_order_vowels = -1,
        res_order_consonants = -1,
        res_order_digits = -1,
        res_order_consonant_digits = -1,
        ratio_uppercase_length = -1,
        ratio_consonants_length = -1,
        ratio_vowels_length = -1,
        ratio_digits_length = -1,
        ratio_consonant_digits_length = -1
    }

    if login ~= "" then
        dict_login_processing = login_processing(login)
    end

    local diff_phone_country_from_rbl = -1;
    if phone_number ~= "" and iso_name_rbl ~= "" then
        local parsed = libphonenumber.parse(phone_number);
        if parsed:regionCodeForNumber() == iso_name_rbl then
            diff_phone_country_from_rbl = 1
        else diff_phone_country_from_rbl = 0
        end
    else
        diff_phone_country_from_rbl = -1
    end




    num_features["ip_countries_cnt_d"] = process_num_features(aggregates["ip_countries_cnt_d"])
    num_features["ip_foreign_uids_cnt_d"] = process_num_features(aggregates["ip_foreign_uids_cnt_d"])
    num_features["ip_tnx_cnt_d"] = process_num_features(aggregates["ip_tnx_cnt_d"])
    num_features["ip_uids_cnt_d"] = process_num_features(aggregates["ip_uids_cnt_d"])
    num_features["ip_uids_cnt_m"] = process_num_features(aggregates["ip_uids_cnt_m"])
    num_features["mail_ips_cnt_w"] = process_num_features(aggregates["mail_ips_cnt_w"])
    num_features["mail_uids_cnt_w"] = process_num_features(aggregates["mail_uids_cnt_w"])
    num_features["mail_tnx_cnt_w"] = process_num_features(aggregates["mail_tnx_cnt_w"])

    num_features["uid_countries_cnt_d"] = process_num_features(aggregates["uid_countries_cnt_d"])
    num_features["uid_foreign_ip_tnx_cnt_d"] = process_num_features(aggregates["uid_foreign_ip_tnx_cnt_d"])
    num_features["uid_foreign_ips_cnt_d"] = process_num_features(aggregates["uid_foreign_ips_cnt_d"])
    num_features["uid_ips_cnt_d"] = process_num_features(aggregates["uid_ips_cnt_d"])
    num_features["uid_tnx_cnt_d"] = process_num_features(aggregates["uid_tnx_cnt_d"])


    cat_features["action"] = request_data.action or ""
    num_features["captchacount"] = process_num_features(request_data.captchacount)
    cat_features["consumer"] = request_data.consumer or ""
    cat_features["host"] = request_data.host or ""
    --cat_features["ip"] = request_data.ip or ""
    cat_features["v2_accept_language"] = request_data.v2_accept_language or ""
    cat_features["country_from_rbl"] = country_id
    --cat_features["region_id"] = region_id

    cat_features["city_rbl"] = city_id

    --cat_features["provider"] = provider
    cat_features["asset_rbl"] = asset
    cat_features["iso_name_rbl"] = iso_name_rbl

    cat_features["is_suggested_login"] = process_num_features(request_data.is_suggested_login)
    cat_features["lang"] = request_data.lang or ""
    cat_features["lcheck"] = process_num_features(request_data.lcheck)
    --cat_features["passwd"] = request_data.passwd or ""
    num_features["passwd_0"] = process_num_features(passwd[2])
    num_features["passwd_1"] = process_num_features(passwd[2])
    num_features["passwd_2"] = process_num_features(passwd[3])
    num_features["passwd_3"] = process_num_features(passwd[4])
    --cat_features["passwdex"] = request_data.passwdex or ""
    num_features["passwdex_0"] = process_num_features(passwdex[1])
    num_features["passwdex_1"] = process_num_features(passwdex[2])
    num_features["passwdex_2"] = process_num_features(passwdex[3])
    num_features["passwdex_3"] = process_num_features(passwdex[4])
    cat_features["proxyvalue"] = tonumber(request_data.proxyvalue) or -1

    cat_features["day_part"] = process_num_features(day_part)
    --cat_features["weekday"] = weekday
    cat_features["hour"] = process_num_features(hour)
    --cat_features["month"] = month

    cat_features["is_mobile"] = process_num_features(is_mobile)
    cat_features["browser_name"] = browser_name or ""
    cat_features["browser_version"] = browser_version or ""
    cat_features["os_family"] = os_family or ""
    cat_features["os_version"] = os_version or ""

    --cat_features["v2_account_country"] = request_data.v2_account_country or ""
    --cat_features["v2_account_language"] = request_data.v2_account_language or ""
    cat_features["tzname_rbl"] = tzname_rbl or ""

    if ((request_data.v2_app_uuid) and not (request_data.v2_app_uuid == "")) then
        cat_features["v2_app_uuid"] = 1
    else
        cat_features["v2_app_uuid"] = 0
    end
    cat_features["v2_application"] = request_data.v2_application or ""
    num_features["v2_captcha_check_count"] = process_num_features(request_data.v2_captcha_check_count)
    cat_features["v2_cell_provider"] = request_data.v2_cell_provider or ""

    if ((request_data.v2_cookie_l_login) and not (request_data.v2_cookie_l_login == "")) then
        cat_features["v2_cookie_l_login"] = 1
    else
        cat_features["v2_cookie_l_login"] = 0
    end
    cat_features["v2_cookie_my_block_count"] = process_num_features(request_data.v2_cookie_my_block_count)
    if ((request_data.v2_hardware_id) and not (request_data.v2_hardware_id == "")) then
        cat_features["v2_hardware_id"] = 1
    else
        cat_features["v2_hardware_id"] = 0
    end
    cat_features["v2_hardware_model"] = request_data.v2_hardware_model or ""

    cat_features["v2_has_cookie_l"] = process_num_features(request_data.v2_has_cookie_l)
    cat_features["v2_has_cookie_my"] = process_num_features(request_data.v2_has_cookie_my)
    cat_features["v2_has_cookie_yandex_login"] = process_num_features(request_data.v2_has_cookie_yandex_login)
    cat_features["v2_has_cookie_yp"] = process_num_features(request_data.v2_has_cookie_yp)
    cat_features["v2_has_cookie_ys"] = process_num_features(request_data.v2_has_cookie_ys)

    cat_features["v2_image_captcha_type"] = request_data.v2_image_captcha_type or ""
    num_features["v2_login_validation_count"] = process_num_features(request_data.v2_login_validation_count)

    if (request_data.v2_page_loading_info) then
        cat_features["v2_page_loading_info"] = 1
    else
        cat_features["v2_page_loading_info"] = 0
    end
    cat_features["v2_password_quality"] = process_num_features(request_data.v2_password_quality)
    num_features["v2_password_validation_count"] = process_num_features(request_data.v2_password_validation_count)
    num_features["v2_phone_bindings_count"] = process_num_features(request_data.v2_phone_bindings_count)
    num_features["v2_phone_confirmation_confirms_count"] = process_num_features(request_data.v2_phone_confirmation_confirms_count)
    cat_features["v2_phone_confirmation_send_count_limit_reached"] = process_num_features(request_data.v2_phone_confirmation_send_count_limit_reached)

    cat_features["v2_phone_confirmation_confirms_count_limit_reached"] = process_num_features(request_data.v2_phone_confirmation_confirms_count_limit_reached)
    cat_features["v2_phone_confirmation_send_ip_limit_reached"] = process_num_features(request_data.v2_phone_confirmation_send_ip_limit_reached)
    num_features["v2_phone_confirmation_sms_count"] = process_num_features(request_data.v2_phone_confirmation_sms_count)
    cat_features["v2_phone_validation_changes"] = process_num_features(request_data.v2_phone_validation_changes)
    num_features["v2_phone_validation_error"] = process_num_features(request_data.v2_phone_validation_error)
    num_features["v2_sanitize_phone_count"] = process_num_features(request_data.v2_sanitize_phone_count)
    num_features["v2_suggest_login_length"] = process_num_features(request_data.v2_suggest_login_length)
    cat_features["xcountry"] = request_data.xcountry or ""
    num_features["entropy_login"] = process_num_features(entropy_login)
    num_features["entropy_small_login_part"] = process_num_features(entropy_small_login_part)
    num_features["entropy_big_login_part"] = process_num_features(entropy_big_login_part)


    cat_features["is_hosting"] = tonumber(is_hosting) or -1
    cat_features["is_tor"] = tonumber(is_tor) or -1
    cat_features["is_yandex_net"] = tonumber(is_yandex_net) or -1
    cat_features["is_yandex_turbo"] = tonumber(is_yandex_turbo) or -1
    cat_features["is_vpn"] = tonumber(is_vpn) or -1
    cat_features["org_name"] = org_name or ""
    cat_features["isp_name"] = isp_name or ""
    cat_features["with_phones"] = tonumber(with_phones) or -1
    cat_features["is_proxy"] = tonumber(is_proxy) or -1


    cat_features["diff_country_from_rbl_from_bb"] = tonumber(diff_country_from_rbl_from_bb) or -1
    cat_features["diff_phone_country_from_rbl"] = tonumber(diff_phone_country_from_rbl) or -1
    cat_features["domen"] = domen or ""
    cat_features["diff_email_login"] = tonumber(diff_email_login) or -1
    cat_features["diff_lang_fpt_lamg_ip"] = tonumber(diff_lang_fpt_lamg_ip) or -1


    for feature, value in pairs(dict_login_processing) do
        num_features[feature] = value;
    end

    return num_features, cat_features;
end

local num_features, cat_features = module.make_features({
aggrs = {},
rbl = nil,
raw_bb = {
    ["aliases"] = {
        ["1"] = "yndx-theweed"
    },
    ["attributes"] = {
        ["1"] = "1658785700",
        ["31"] = "ru",
        ["34"] = "ru"
    },
    ["dbfields"] = {
        ["userinfo.sex.uid"] = "0"
    },
    ["display_name"] = {
        ["avatar"] = {
            ["default"] = "0/0-0",
            ["empty"] = true
        },
        ["has_public_profile"] = true,
        ["name"] = "yndx-theweed",
        ["public_name"] = "Давид Давыдов",
        ["third_party_can_use"] = true
    },
    ["family_info"] = {},
    ["have_hint"] = false,
    ["have_password"] = false,
    ["id"] = "1666438035",
    ["karma"] = {
        ["value"] = 0
    },
    ["karma_status"] = {
        ["value"] = 0
    },
    ["login"] = "yndx-theweed",
    ["phones"] = {},
    ["regname"] = "yndx-theweed",
    ["uid"] = {
        ["hosted"] = false,
        ["lite"] = false,
        ["value"] = "1666438035"
    }
},
src = {
    ["actiface"] = "check",
    ["action"] = "admreg",
    ["captchacount"] = "",
    ["captchareq"] = "0",
    ["channel"] = "auth",
    ["consumer"] = "idm",
    ["email"] = "theweed@yandex-team.ru",
    ["external_id"] = "17945226804104512941",
    ["fname"] = "�������",
    ["from"] = "",
    ["fuid"] = "",
    ["hinta"] = "0.0.0.0.0.0",
    ["hintaex"] = "0.0.0.0.0.0",
    ["hintq"] = "0.0.0.0.0.0",
    ["hintqex"] = "0.0.0.0.0.0",
    ["hintqid"] = "",
    ["host"] = "passport-internal.yandex.ru",
    ["iname"] = "�����",
    ["ip"] = "2a02:6b8:c14:3494:0:4465:ae7b:0",
    ["ip_from"] = "2a02:6b8:c14:3494:0:4465:ae7b:0",
    ["ip_prox"] = "",
    ["is_suggested_login"] = "",
    ["lang"] = "ru",
    ["lcheck"] = "",
    ["login"] = "yndx-theweed",
    ["origin"] = "",
    ["passwd"] = "0.0.0.0.0.0.0.0",
    ["passwdex"] = "0.0.0.0.0.0.0.0",
    ["phonenumber"] = "",
    ["request"] = "auth",
    ["so_codes"] = "utf8",
    ["social_provider"] = "",
    ["step1time"] = "2000",
    ["step2time"] = "2000",
    ["sub_channel"] = "registration",
    ["t"] = 1658785700000,
    ["time"] = "1658785700",
    ["uid"] = "1666438035",
    ["useragent"] = "idm",
    ["utime"] = "1658785700728",
    ["v2_accept_language"] = "",
    ["v2_account_country"] = "ru",
    ["v2_account_karma"] = "",
    ["v2_account_language"] = "ru",
    ["v2_account_timezone"] = "Europe/Moscow",
    ["v2_app_uuid"] = "",
    ["v2_application"] = "",
    ["v2_captcha_check_count"] = "",
    ["v2_captcha_checked_at"] = "",
    ["v2_captcha_generated_at"] = "",
    ["v2_cell_provider"] = "",
    ["v2_clid"] = "",
    ["v2_cookie_l_login"] = "",
    ["v2_cookie_l_timestamp"] = "",
    ["v2_cookie_l_uid"] = "",
    ["v2_cookie_my_block_count"] = "",
    ["v2_cookie_my_language"] = "",
    ["v2_geo_coarse"] = "",
    ["v2_hardware_id"] = "",
    ["v2_hardware_model"] = "",
    ["v2_has_cookie_l"] = "0",
    ["v2_has_cookie_my"] = "0",
    ["v2_has_cookie_yandex_login"] = "0",
    ["v2_has_cookie_yp"] = "0",
    ["v2_has_cookie_ys"] = "0",
    ["v2_image_captcha_type"] = "",
    ["v2_ip"] = "2a02:6b8:c14:3494:0:4465:ae7b:0",
    ["v2_is_ssl"] = "1",
    ["v2_is_ssl_session_cookie_valid"] = "",
    ["v2_language_sys"] = "",
    ["v2_locale"] = "",
    ["v2_login_validation_count"] = "",
    ["v2_login_validation_first_call"] = "",
    ["v2_login_validation_last_call"] = "",
    ["v2_old_password_quality"] = "",
    ["v2_os_id"] = "",
    ["v2_page_loading_info"] = "",
    ["v2_password_quality"] = "",
    ["v2_password_validation_count"] = "",
    ["v2_password_validation_first_call"] = "",
    ["v2_password_validation_last_call"] = "",
    ["v2_phone_bindings_count"] = "0",
    ["v2_phone_confirmation_confirms_count"] = "",
    ["v2_phone_confirmation_confirms_count_limit_reached"] = "",
    ["v2_phone_confirmation_first_code_checked"] = "",
    ["v2_phone_confirmation_first_sms_send_at"] = "",
    ["v2_phone_confirmation_last_code_checked"] = "",
    ["v2_phone_confirmation_last_sms_send_at"] = "",
    ["v2_phone_confirmation_send_count_limit_reached"] = "",
    ["v2_phone_confirmation_send_ip_limit_reached"] = "",
    ["v2_phone_confirmation_sms_count"] = "",
    ["v2_phone_validation_changes"] = "",
    ["v2_phone_validation_error"] = "",
    ["v2_phonenumber_hash"] = "",
    ["v2_sanitize_phone_count"] = "",
    ["v2_sanitize_phone_first_call"] = "",
    ["v2_sanitize_phone_last_call"] = "",
    ["v2_session_age"] = "",
    ["v2_session_create_timestamp"] = "",
    ["v2_session_ip"] = "",
    ["v2_suggest_login_first_call"] = "",
    ["v2_suggest_login_last_call"] = "",
    ["v2_suggest_login_length"] = "",
    ["v2_track_created"] = "1658785700.21",
    ["v2_voice_captcha_type"] = "",
    ["v2_yandex_gid"] = "",
    ["valkey"] = "0000000000",
    ["xcountry"] = "ru",
    ["yandexuid"] = "",
    ["yid"] = ""
}
});

util.assert_equals({
    ["diff_country_from_rbl_from_bb"] = -1,
    ["v2_application"] = "",
    ["hour"] = 0,
    ["day_part"] = 0,
    ["v2_phone_validation_changes"] =  0,
    ["host"] = "passport-internal.yandex.ru",
    ["os_family"] = "Unknown",
    ["v2_password_quality"] = 0,
    ["with_phones"] = 0,
    ["city_rbl"] = "",
    ["asset_rbl"] = "",
    ["v2_phone_confirmation_send_count_limit_reached"] =  0,
    ["iso_name_rbl"] = "",
    ["v2_accept_language"] = "",
    ["v2_has_cookie_l"] = 0,
    ["tzname_rbl"] = "",
    ["domen"] = "",
    ["is_suggested_login"] =  0,
    ["v2_hardware_model"] = "",
    ["is_mobile"] =  0,
    ["browser_name"] = "Unknown",
    ["lang"] = "ru",
    ["is_vpn"] = -1,
    ["is_proxy"] = -1,
    ["action"] = "admreg",
    ["v2_phone_confirmation_confirms_count_limit_reached"] =  0,
    ["v2_has_cookie_yp"] = 0,
    ["v2_has_cookie_yandex_login"] = 0,
    ["diff_lang_fpt_lamg_ip"] = -1,
    ["os_version"] = "",
    ["browser_version"] = "",
    ["proxyvalue"] = -1,
    ["diff_phone_country_from_rbl"] = -1,
    ["v2_has_cookie_ys"] = 0,
    ["v2_has_cookie_my"] = 0,
    ["v2_cookie_l_login"] = 0,
    ["v2_cookie_my_block_count"] = 0,
    ["country_from_rbl"] = "",
    ["xcountry"] = "ru",
    ["v2_cell_provider"] = "",
    ["v2_image_captcha_type"] = "",
    ["v2_phone_confirmation_send_ip_limit_reached"] = 0,
    ["v2_page_loading_info"] = 1,
    ["lcheck"] = 0,
    ["consumer"] = "idm",
    ["diff_email_login"] = -1,
    ["is_yandex_turbo"] = -1,
    ["isp_name"] = "",
    ["is_yandex_net"] = -1,
    ["is_hosting"] = -1,
    ["v2_app_uuid"] = 0,
    ["v2_hardware_id"] = 0,
    ["is_tor"] = -1,
    ["org_name"] = ""
}, cat_features);


util.assert_equals({
    ["passwd_2"] = 0,
    ["res_order_consonants"] = 4,
    ["v2_phone_validation_error"] = 0,
    ["v2_captcha_check_count"] = 0,
    ["v2_login_validation_count"] = 0,
    ["lenght"] = 12,
    ["digits"] = 0,
    ["v2_password_validation_count"] = 0,
    ["mail_tnx_cnt_w"] = 0,
    ["ip_uids_cnt_d"] = 0,
    ["ratio_vowels_length"] = 0.25,
    ["symbols"] = 1,
    ["passwd_0"] = 0,
    ["res_order_vowels"] = 2,
    ["res_order_consonant_digits"] = 4,
    ["v2_suggest_login_length"] = 0,
    ["ip_uids_cnt_m"] = 0,
    ["passwdex_2"] = 0,
    ["upper"] = 0,
    ["passwdex_1"] = 0,
    ["ip_countries_cnt_d"] = 0,
    ["entropy_small_login_part"] = 13862,
    ["uid_countries_cnt_d"] = 0,
    ["ratio_consonant_digits_length"] = 0.6666667,
    ["ratio_digits_length"] = 0,
    ["v2_sanitize_phone_count"] = 0,
    ["vowels"] = 3,
    ["uid_ips_cnt_d"] = 0,
    ["ratio_consonants_length"] = 0.6666667,
    ["ip_tnx_cnt_d"] = 0,
    ["ip_foreign_uids_cnt_d"] = 0,
    ["captchacount"] = 0,
    ["mail_uids_cnt_w"] = 0,
    ["entropy_big_login_part"] = 14750,
    ["v2_phone_confirmation_confirms_count"] = 0,
    ["ratio_uppercase_length"] = 0.0,
    ["passwd_3"] = 0,
    ["entropy_login"] = 20947,
    ["v2_phone_bindings_count"] = 0,
    ["passwdex_3"] = 0,
    ["mail_ips_cnt_w"] = 0,
    ["uid_foreign_ip_tnx_cnt_d"] = 0,
    ["passwd_1"] = 0,
    ["uid_foreign_ips_cnt_d"] = 0,
    ["consonant_digits"] = 8,
    ["res_order_digits"] = 0,
    ["uid_tnx_cnt_d"] = 0,
    ["consonant"] = 8,
    ["v2_phone_confirmation_sms_count"] = 0,
    ["passwdex_0"] = 0
}, num_features);

return module;
