package ru.yandex.mail.so.clip;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.mail.so.factors.BasicSoFunctionInputs;
import ru.yandex.mail.so.factors.LoggingFactorsAccessViolationHandler;
import ru.yandex.mail.so.factors.http.HttpSoFactorsExtractorContext;
import ru.yandex.mail.so.factors.types.JsonMapSoFactorType;
import ru.yandex.parser.mail.errors.ErrorsLogger;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestsStater;
import ru.yandex.util.timesource.TimeSource;

public class ClipHandler
    implements HttpAsyncRequestHandler<JsonObject>
{
    private final ClipServer server;
    private final int maxChangeSize;
    private final RequestsStater incomingLagStater;

    public ClipHandler(
        final ClipServer server,
        final int maxChangeSize,
        final RequestsStater incomingLagStater)
    {
        this.server = server;
        this.maxChangeSize = maxChangeSize;
        this.incomingLagStater = incomingLagStater;
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity =
                ((HttpEntityEnclosingRequest) request).getEntity();
            if (entity.getContentLength() != 0) {
                return new JsonAsyncTypesafeDomConsumer(
                    entity,
                    StringCollectorsFactory.INSTANCE,
                    BasicContainerFactory.INSTANCE);
            }
        }
        throw new BadRequestException("Payload expected");
    }

    @Override
    public void handle(
        final JsonObject change,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        ErrorsLogger errorsLogger = new ErrorsLogger(session.logger());
        LoggingFactorsAccessViolationHandler accessViolationHandler =
            new LoggingFactorsAccessViolationHandler(
                server.extractors().violationsCounter(),
                session.logger());
        HttpSoFactorsExtractorContext extractorContext =
            new HttpSoFactorsExtractorContext(
                session,
                accessViolationHandler,
                errorsLogger,
                server.threadPool());
        try {
            Double operationDate =
                session.params().getDouble("operation-date", null);
            if (operationDate != null) {
                long operationDateMs =
                    (long) (operationDate.doubleValue() * 1000d);
                long now = TimeSource.INSTANCE.currentTimeMillis();
                long lag = now - operationDateMs;
                session.logger().fine("Incoming lag: " + lag + " ms");
                incomingLagStater.accept(
                    new RequestInfo(
                        now,
                        0,
                        operationDateMs,
                        operationDateMs,
                        0L,
                        0L));
            }

            OffsetCallback callback =
                new OffsetCallback(session, change.asMap(), maxChangeSize);
            server.extractors().extract(
                "main",
                extractorContext,
                new BasicSoFunctionInputs(
                    accessViolationHandler,
                    JsonMapSoFactorType.JSON_MAP.createFactor(
                        callback.change())),
                callback);
        } catch (JsonException e) {
            throw new BadRequestException(e);
        }
    }
}

