package ru.yandex.mail.so.clip;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;

import ru.yandex.collection.Pattern;
import ru.yandex.http.server.async.PingHandler;
import ru.yandex.mail.so.clip.config.ImmutableClipConfig;
import ru.yandex.mail.so2.skeleton.So2SkeletonServer;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.stater.RequestTimeHistogramMetric;
import ru.yandex.stater.RequestsStater;

public class ClipServer extends So2SkeletonServer<ImmutableClipConfig> {
    public ClipServer(final ImmutableClipConfig config)
        throws ConfigException, IOException
    {
        super(config);

        RequestsStater incomingLagStater =
            new RequestsStater(
                config.metricsTimeFrame(),
                "incoming-lag",
                Collections.singletonList(
                    new RequestTimeHistogramMetric(
                        new IniConfig(
                            new StringReader(
                                "histogram-ranges = 0, 100, 300, 600, 1000, "
                                + "3000, 6000, 10000, 30000, 60000, 100000, "
                                + "300000, 600000, 1200000\n"
                                + "precise-histogram = false\n"
                                + "processing-time-stats = false")))),
                "lag",
                "Requests lag");
        registerStater(incomingLagStater);

        register(
            new Pattern<>("/notify", false),
            new ClipHandler(this, config.maxChangeSize(), incomingLagStater));
        register(new Pattern<>("", true), new PingHandler(this));
    }
}

