package ru.yandex.mail.so.clip;

import java.util.Objects;

import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.parser.uri.PctEncodedString;
import ru.yandex.parser.uri.QueryParameter;
import ru.yandex.parser.uri.UriParser;

public class OffsetCallback extends AbstractProxySessionCallback<Object> {
    private final JsonMap change;
    private final int nextOffset;

    public OffsetCallback(
        final ProxySession session,
        final JsonMap change,
        final int maxChangeSize)
        throws HttpException, JsonException
    {
        super(session);
        this.change = change;
        JsonList changed =
            Objects.requireNonNullElse(
                change.get("changed").asListOrNull(),
                JsonList.EMPTY);
        int changedSize = changed.size();
        int offset = session.params().get(
            "change_offset",
            0,
            NonNegativeIntegerValidator.INSTANCE);
        int endPos = Math.min(offset + maxChangeSize, changedSize);
        if (endPos == changedSize) {
            nextOffset = 0;
        } else {
            nextOffset = endPos;
        }
        if (offset != 0 || endPos != changedSize) {
            JsonList changedPart =
                new JsonList(BasicContainerFactory.INSTANCE, endPos - offset);
            changedPart.addAll(changed.subList(offset, endPos));
            change.put("changed", changedPart);
        }
        StringBuilder sb = new StringBuilder("change_log data to process: ");
        JsonType.NORMAL.toStringBuilder(sb, change);
        session.logger().fine(new String(sb));
    }

    public JsonMap change() {
        return change;
    }

    @Override
    public void completed(final Object result) {
        if (nextOffset == 0) {
            session.response(HttpStatus.SC_OK);
        } else {
            String uri = session.request().getRequestLine().getUri();
            String location =
                new UriParser(uri)
                    .addOrReplaceCgiParameter(
                        new QueryParameter(
                            "change_offset",
                            new PctEncodedString(
                                Integer.toString(nextOffset),
                                null)));
            session.logger().info("Redirecting " + uri + " to " + location);
            session.getResponse().addHeader(HttpHeaders.LOCATION, location);
            session.response(HttpStatus.SC_TEMPORARY_REDIRECT);
        }
    }
}

