package ru.yandex.mail.so.clip.config;

import ru.yandex.mail.so2.skeleton.config.AbstractSo2SkeletonConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractClipConfigBuilder
    <T extends AbstractClipConfigBuilder<T>>
    extends AbstractSo2SkeletonConfigBuilder<T>
    implements ClipConfig
{
    private int maxChangeSize;

    protected AbstractClipConfigBuilder(final ClipConfig config) {
        super(config);
        maxChangeSize(config.maxChangeSize());
    }

    protected AbstractClipConfigBuilder(
        final IniConfig config,
        final ClipConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        maxChangeSize =
            MAX_CHANGE_SIZE.extract(config, defaults.maxChangeSize());
    }

    @Override
    public int maxChangeSize() {
        return maxChangeSize;
    }

    public T maxChangeSize(final int maxChangeSize) {
        this.maxChangeSize = maxChangeSize;
        return self();
    }
}

