package ru.yandex.mail.so.clip.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ClipConfigBuilder
    extends AbstractClipConfigBuilder<ClipConfigBuilder>
{
    public ClipConfigBuilder() {
        super(ClipConfigDefaults.INSTANCE);
    }

    public ClipConfigBuilder(final ClipConfig config) {
        super(config);
    }

    public ClipConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, ClipConfigDefaults.INSTANCE);
    }

    public ClipConfigBuilder(final IniConfig config, final ClipConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ClipConfigBuilder self() {
        return this;
    }

    public ImmutableClipConfig build() throws ConfigException {
        return new ImmutableClipConfig(this);
    }
}

