package ru.yandex.mail.so.clip.config;

import ru.yandex.mail.so2.skeleton.config.ImmutableSo2SkeletonConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableClipConfig
    extends ImmutableSo2SkeletonConfig
    implements ClipConfig
{
    private final int maxChangeSize;

    public ImmutableClipConfig(final ClipConfig config)
        throws ConfigException
    {
        super(config);
        maxChangeSize = MAX_CHANGE_SIZE.validate(config.maxChangeSize());
    }

    @Override
    public int maxChangeSize() {
        return maxChangeSize;
    }
}

