#!/bin/bash
set -exo pipefail

source recommended_java_args.sh

# reserve 1 core for various overheads
export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{cores=int($1) - 4; if (cores < 2) {cores = 2;} print cores}')
export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.8)}')

GB=$(( 1024*1024*1024 ))
GB2=$(( GB + GB ))
export MEMORY_GAP=${MEMORY_GAP:-$GB2}

export ROOT=.
export CLIP_PORT=80
export CONSUMER_PORT=81
export NGINX_PORT=82
export MAX_CHANGE_SIZE=100
export TVM_API_HOST=https://tvm-api.yandex.net
export APE_TVM_CLIENT_ID=200
export NGINX_TEMP_PATH=/logs/nginx-temp-files

export TVM_CLIENT_ID=2000031
export BLACKBOX_HOST=http://blackbox-mail.yandex.net
export BLACKBOX_TVM_CLIENT_ID=222
export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
export CORP_BLACKBOX_TVM_CLIENT_ID=223
export TIKAITE_HOST=http://tikaite.ape.yandex.net
export SRW_TVM_CLIENT_ID=2000273
export FILTER_SEARCH_HOST=http://meta-qloud.mail.yandex.net
export FILTER_SEARCH_TVM_ID=2000499
export CORP_FILTER_SEARCH_HOST=http://metacorp.mail.yandex.net
export CORP_FILTER_SEARCH_TVM_ID=2000500
export PRODUCER_HOST=http://salo-producer.search.yandex.net:8081

if [ "$INSTANCE_TAG_CTYPE" = "test" ]
then
    export TVM_CLIENT_ID=186
    export BLACKBOX_HOST=http://pass-test.yandex.ru
    export BLACKBOX_TVM_CLIENT_ID=224
    export CORP_BLACKBOX_HOST=http://pass-test.yandex.ru
    export CORP_BLACKBOX_TVM_CLIENT_ID=225
    export TIKAITE_HOST=http://tikaite.tst.ape.yandex.net
    export SRW_TVM_CLIENT_ID=2000272
    export FILTER_SEARCH_HOST=http://meta-test.mail.yandex.net
    export FILTER_SEARCH_TVM_ID=2000501
    export CORP_FILTER_SEARCH_HOST=http://meta-test.mail.yandex.net
    export CORP_FILTER_SEARCH_TVM_ID=2000501
    export PRODUCER_HOST=http://salo-producer-test.n.yandex-team.ru
fi

