pragma critical;

create blackbox_userinfo extractor uid_resolver(long uid) -> userinfo {
    dbfields = suid

    [blackbox]
    host = $(BLACKBOX_HOST)
    connections = 10
    pass-referer = false
    timeout = 1s
    tvm-client-id = $(BLACKBOX_TVM_CLIENT_ID)

    [blackbox.stat]
    prefix = blackbox
    metrics = httpcodes, requesttimes, requesthist
    histogram-ranges = 0, 1, 10, 20, 50, 100, 150, 200, 300, 500, 750, 1000
    precise-histogram = false
    processing-time-stats = false

    [blackbox.http-error-retries]
    interval = 50ms
    count = 1

    [blackbox.io-error-retries]
    interval = 50ms
    count = 1

    [corp-blackbox]
    host = $(CORP_BLACKBOX_HOST)
    connections = 10
    pass-referer = false
    timeout = 1s
    tvm-client-id = $(CORP_BLACKBOX_TVM_CLIENT_ID)

    [corp-blackbox.stat]
    prefix = corp-blackbox
    metrics = httpcodes, requesttimes, requesthist
    histogram-ranges = 0, 1, 10, 20, 50, 100, 150, 200, 300, 500, 750, 1000
    precise-histogram = false
    processing-time-stats = false

    [corp-blackbox.http-error-retries]
    interval = 50ms
    count = 1

    [corp-blackbox.io-error-retries]
    interval = 50ms
    count = 1
}

create http_get extractor tikaite_headers(string stid) -> json_object {
    uri = $(TIKAITE_HOST)/headers?json-type=dollar&stid=
    connections = 100
    pass-referer = false
    tvm-headers = X-Ya-Service-Ticket: $(APE_TVM_CLIENT_ID), X-Srw-Service-Ticket: $(SRW_TVM_CLIENT_ID)
    suppress-error-types = non-retriable

    [timeout]
    connect = 1s
    pool = 2s
    socket = 20s

    [http-error-retries]
    interval = 3s
    count = 3

    [io-error-retries]
    interval = 3s
    count = 3

    [stat]
    prefix = tikaite-headers
    metrics = httpcodes, requesttimes, requesthist
    httpcode-ranges = total, 200-299, 400-403 (4xx), 404, 405-498 (4xx), 499, 500-599
    histogram-ranges = 0, 50, 100, 200, 300, 500, 750, 1000, 3000
    precise-histogram = false
    processing-time-stats = false
}

create received_chain extractor received_info(json_list headers, boolean skip_external_bys) -> received_chain {
    [yandex-nets]
    file = $(ROOT)/yandex-nets.txt
}

create filter_search extractor filter_search(json_map change) -> json_map {
    uri = $(FILTER_SEARCH_HOST)/filter_search
    connections = 20
    pass-referer = false
    tvm-client-id = $(FILTER_SEARCH_TVM_ID)

    [timeout]
    connect = 1s
    pool = 3s
    socket = 10s

    [http-error-retries]
    interval = 1s
    count = 2

    [io-error-retries]
    interval = 1s
    count = 2

    [stat]
    prefix = filter-search
    metrics = httpcodes, requesttimes, requesthist
    histogram-ranges = 0, 50, 100, 200, 300, 500, 750, 1000, 3000
    precise-histogram = false
    processing-time-stats = false

    [corp]
    uri = $(CORP_FILTER_SEARCH_HOST)/filter_search
    connections = 20
    pass-referer = false
    tvm-client-id = $(CORP_FILTER_SEARCH_TVM_ID)

    [corp.timeout]
    connect = 1s
    pool = 3s
    socket = 10s

    [corp.http-error-retries]
    interval = 1s
    count = 2

    [corp.io-error-retries]
    interval = 1s
    count = 2

    [corp.stat]
    prefix = corp-filter-search
    metrics = httpcodes, requesttimes, requesthist
    histogram-ranges = 0, 50, 100, 200, 300, 500, 750, 1000, 3000
    precise-histogram = false
    processing-time-stats = false
}

create actions_processor extractor process_actions(actions actions) -> json_object {
    [producer]
    host = $(PRODUCER_HOST)
    connections = 100

    [producer.timeout]
    connect = 1s
    pool = 1s
    socket = 10s

    [producer.http-error-retries]
    interval = 1s
    count = 2

    [producer.io-error-retries]
    interval = 1s
    count = 2

    [producer.stat]
    prefix = producer
    metrics = httpcodes, requesttimes, requesthist
    histogram-ranges = 0, 50, 100, 200, 300, 500, 750, 1000, 3000
    precise-histogram = false
    processing-time-stats = false
}

create chain extractor prepare_tab_pf(json_object single_change, json_map change) -> json_object {
    trace tikaite_headers(single_change.envelope.stid.__string__) -> headers;
    lowercase_headers(headers.headers.__json_list__) -> lowercase_headers;
    senders_info(lowercase_headers) -> senders_info;
    received_info(lowercase_headers, false) -> received_info;
    tab_pf(change.uid.__long__, single_change.tab.__string__, senders_info, received_info) -> pf_info;
    return pf_info;
}

create for_each_json_object extractor prepare_all_tab_pfs(json_list changed, json_map change) -> json_list {
    extractor = prepare_tab_pf
}

create chain extractor prepare_tab_move_actions(json_map change) -> actions {
    prepare_all_tab_pfs(change.changed.__json_list__, change) -> tab_pfs_list;
    convert_tab_pfs_to_actions(change, tab_pfs_list) -> actions;
    return actions if non_empty_json_object(change.changed);
}

create chain extractor handle_user_tab_moves(json_map change, userinfo userinfo) -> actions {
    filter_search(change) -> enriched_change;
    prepare_tab_move_actions(enriched_change) -> actions;
    return actions if non_empty_json_object(userinfo.__json_map__.dbfields.subscription\.suid\.2);
}

create chain extractor handle_tab_moves(json_map change) -> actions {
    uid_resolver(change.uid.__long__) -> userinfo;
    handle_user_tab_moves(change, userinfo) -> actions;
    return actions if non_empty_json_object(change.changed);
}

create chain extractor handle_move(json_map change) -> actions {
    filter_tab_moves(change) -> tab_moves;
    handle_tab_moves(tab_moves) -> actions;
    return actions;
}

create chain extractor prepare_actions(json_map change) -> actions {
    handle_move(change) -> move_actions;
    return move_actions if strings_equal(change.change_type.__string__, "move");
}

create chain extractor main(json_map change) -> json_object {
    prepare_actions(change) -> move_actions;
    trace process_actions(move_actions) -> actions_result;
    return actions_result;
}

