#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

XMX=$(( (MEMORY_LIMIT - MEMORY_GAP) / 1048576))
XMS=$(( XMX / 5 ))
XMN=$(( XMS / 5 ))
GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx${XMX}M
-Xms${XMS}M
-Xmn${XMN}M
-XX:ParallelGCThreads=3
-XX:ConcGCThreads=1
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
"
ADDITIONAL_ARGS="-DPORTO=1 -XX:ActiveProcessorCount=$CPU_CORES -Dru.yandex.dispatcher-zk.reconnect-threads=4"

CLIP_ARGS="ru.yandex.mail.so.clip.ClipServer clip.conf"
CONSUMER_ARGS="ru.yandex.dispatcher.consumer.ConsumerServer -config consumer.conf"

LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    $NET_ARGS $GC_ARGS $ADDITIONAL_ARGS \
    -Djava.library.path=clip_service \
    -cp $CLASSPATH ru.yandex.multistarter.MultiStarter \
    $CLIP_ARGS ";" $CONSUMER_ARGS

