package ru.yandex.mail.so.cretur;

import java.io.IOException;

import io.vertx.core.Vertx;
import org.apache.http.HttpException;

import ru.yandex.client.pg.PgClient;
import ru.yandex.collection.Pattern;
import ru.yandex.function.SimpleGenericAutoCloseableHolder;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.tskv.TskvLoggerProvider;
import ru.yandex.json.parser.JsonException;
import ru.yandex.mail.so.cretur.config.ImmutableCreturConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.tskv.BasicPrefixedTskvLogger;

public class Cretur
    extends HttpProxy<ImmutableCreturConfig>
    implements TskvLoggerProvider
{
    private final PgClient pgClient;
    private final BasicPrefixedTskvLogger tskvLogger;

    public Cretur(final ImmutableCreturConfig config)
        throws ConfigException,
            HttpException,
            IOException,
            InterruptedException,
            JsonException
    {
        super(config);

        try (SimpleGenericAutoCloseableHolder<IOException> holder =
                new SimpleGenericAutoCloseableHolder<>(closeChain))
        {
            Vertx vertx = Vertx.vertx();
            closeChain.add(vertx::close);
            pgClient = new PgClient(vertx, config.pgClientConfig(), logger);
            closeChain.add(pgClient);

            tskvLogger =
                new BasicPrefixedTskvLogger(
                    config.tskvLoggerConfig().build(
                        config.loggers().handlersManager()));
            registerLoggerForLogrotate(tskvLogger.logger());

            register(
                new Pattern<>("/set-organization-ip-whitelist", false),
                new SetOrganizationIpWhitelistHandler(this));

            register(
                new Pattern<>("/delete-organization-ip-whitelist", false),
                new DeleteOrganizationIpWhitelistHandler(this));

            register(
                new Pattern<>("/get-organization-ip-whitelist", false),
                new GetOrganizationIpWhitelistHandler(this));

            register(
                new Pattern<>("/set-organization-daily-limit", false),
                new SetOrganizationDailyLimitHandler(this));

            register(
                new Pattern<>("/delete-organization-daily-limit", false),
                new DeleteOrganizationDailyLimitHandler(this));

            register(
                new Pattern<>("/get-organization-daily-limit", false),
                new GetOrganizationDailyLimitHandler(this));

            register(
                new Pattern<>("/get-all-organizations-settings", false),
                new GetAllOrganizationsSettingsHandler(this));

            holder.release();
        }
    }

    public PgClient pgClient() {
        return pgClient;
    }

    @Override
    public BasicPrefixedTskvLogger tskvLogger() {
        return tskvLogger;
    }
}

