package ru.yandex.mail.so.cretur;

import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.client.pg.PgClient;
import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.proxy.StaticEntitySendingCallback;
import ru.yandex.http.tskv.TskvProxySession;
import ru.yandex.http.util.nio.FakeAsyncConsumer;

public class DeleteOrganizationDailyLimitHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final SqlQuery DELETE_ORGANIZATION_DAILY_LIMIT =
        new SqlQuery(
            "delete-organization-daily-limit.sql",
            DeleteOrganizationDailyLimitHandler.class);

    private final Cretur server;

    public DeleteOrganizationDailyLimitHandler(final Cretur server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        long orgId = session.params().getLong("org_id");
        deleteOrganizationDailyLimit(
            server.pgClient(),
            orgId,
            new TskvProxySession(
                session,
                server,
                this,
                "Deleting organization daily limit",
                TskvFields.ORG_ID,
                Long.toString(orgId)));
    }

    public static void deleteOrganizationDailyLimit(
        final PgClient pgClient,
        final long orgId,
        final ProxySession session)
    {
        pgClient.executeOnMaster(
            DELETE_ORGANIZATION_DAILY_LIMIT,
            Tuple.of(orgId),
            session.listener(),
            new StaticEntitySendingCallback<>(
                session,
                rowSet -> "Rows affected by delete: " + rowSet.rowCount()));
    }
}

