package ru.yandex.mail.so.cretur;

import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.client.pg.PgClient;
import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.proxy.StaticEntitySendingCallback;
import ru.yandex.http.tskv.TskvProxySession;
import ru.yandex.http.util.nio.FakeAsyncConsumer;

public class DeleteOrganizationIpWhitelistHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final SqlQuery DELETE_ORGANIZATION_IP_WHITELIST =
        new SqlQuery(
            "delete-organization-ip-whitelist.sql",
            DeleteOrganizationIpWhitelistHandler.class);

    private final Cretur server;

    public DeleteOrganizationIpWhitelistHandler(final Cretur server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        long orgId = session.params().getLong("org_id");
        deleteOrganizationIpWhitelist(
            server.pgClient(),
            orgId,
            new TskvProxySession(
                session,
                server,
                this,
                "Deleting organization ip whitelist",
                TskvFields.ORG_ID,
                Long.toString(orgId)));
    }

    public static void deleteOrganizationIpWhitelist(
        final PgClient pgClient,
        final long orgId,
        final ProxySession session)
    {
        pgClient.executeOnMaster(
            DELETE_ORGANIZATION_IP_WHITELIST,
            Tuple.of(orgId),
            session.listener(),
            new StaticEntitySendingCallback<>(
                session,
                rowSet -> "Rows affected by delete: " + rowSet.rowCount()));
    }
}

