package ru.yandex.mail.so.cretur;

import java.io.IOException;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class GetOrganizationIpWhitelistHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final SqlQuery GET_ORGANIZATION_IP_WHITELIST =
        new SqlQuery(
            "get-organization-ip-whitelist.sql",
            GetOrganizationIpWhitelistHandler.class);

    private final Cretur server;

    public GetOrganizationIpWhitelistHandler(final Cretur server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        server.pgClient().executeOnMaster(
            GET_ORGANIZATION_IP_WHITELIST,
            Tuple.of(session.params().getLong("org_id")),
            session.listener(),
            new Callback(session));
    }

    private static class Callback
        extends AbstractProxySessionCallback<RowSet<Row>>
    {
        private final JsonType jsonType;

        Callback(final ProxySession session) throws HttpException {
            super(session);
            jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        }

        @Override
        public void completed(final RowSet<Row> rowSet) {
            try {
                int rowCount = rowSet.rowCount();
                session.logger().info("Row count: " + rowCount);
                if (rowCount == 0) {
                    session.response(HttpStatus.SC_NOT_FOUND);
                } else {
                    Row row = rowSet.iterator().next();
                    StringBuilderWriter sbw = new StringBuilderWriter();
                    try (JsonWriter writer = jsonType.create(sbw)) {
                        writer.startObject();
                        writer.key("ip_whitelist");
                        writer.startArray();
                        for (String ip: row.getArrayOfStrings("ip_whitelist")) {
                            writer.value(ip);
                        }
                        writer.endArray();
                        writer.endObject();
                    }
                    session.response(
                        HttpStatus.SC_OK,
                        new NStringEntity(
                            sbw.toString(),
                            ContentType.APPLICATION_JSON.withCharset(
                                session.acceptedCharset())));
                }
            } catch (IOException | RuntimeException e) {
                failed(e);
            }
        }
    }
}

