package ru.yandex.mail.so.cretur;

import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.proxy.StaticEntitySendingCallback;
import ru.yandex.http.tskv.TskvProxySession;
import ru.yandex.http.util.nio.FakeAsyncConsumer;

public class SetOrganizationDailyLimitHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final SqlQuery SET_ORGANIZATION_DAILY_LIMIT =
        new SqlQuery(
            "set-organization-daily-limit.sql",
            SetOrganizationDailyLimitHandler.class);

    private final Cretur server;

    public SetOrganizationDailyLimitHandler(final Cretur server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession basicSession =
            new BasicProxySession(server, exchange, context);
        long orgId = basicSession.params().getLong("org_id");
        long dailyLimit = basicSession.params().getLong("daily_limit");

        TskvProxySession session =
            new TskvProxySession(
                basicSession,
                server,
                this,
                "Setting organization daily limit to " + dailyLimit,
                TskvFields.ORG_ID,
                Long.toString(orgId));

        if (dailyLimit == -1L) {
            DeleteOrganizationDailyLimitHandler.deleteOrganizationDailyLimit(
                server.pgClient(),
                orgId,
                session);
        } else {
            Tuple tuple = Tuple.tuple();
            tuple.addLong(orgId);
            tuple.addLong(dailyLimit);

            server.pgClient().executeOnMaster(
                SET_ORGANIZATION_DAILY_LIMIT,
                tuple,
                session.listener(),
                new StaticEntitySendingCallback<>(
                    session,
                    rowSet ->
                        "Rows affected by update: " + rowSet.rowCount()));
        }
    }
}

