package ru.yandex.mail.so.cretur.config;

import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractCreturConfigBuilder
    <T extends AbstractCreturConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements CreturConfig
{
    private int ipWhitelistMaxSize;
    private PgClientConfigBuilder pgClientConfig;
    private LoggerConfigBuilder tskvLoggerConfig;

    protected AbstractCreturConfigBuilder(
        final CreturConfig config)
    {
        super(config);
        ipWhitelistMaxSize(config.ipWhitelistMaxSize());
        pgClientConfig(config.pgClientConfig());
        tskvLoggerConfig(config.tskvLoggerConfig());
    }

    protected AbstractCreturConfigBuilder(
        final IniConfig config,
        final CreturConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        ipWhitelistMaxSize =
            IP_WHITELIST_MAX_SIZE.extract(
                config,
                defaults.ipWhitelistMaxSize());
        pgClientConfig = PG_CLIENT.extract(config, defaults.pgClientConfig());
        tskvLoggerConfig =
            TSKV_LOGGER_CONFIG.extract(config, defaults.tskvLoggerConfig());
    }

    @Override
    public int ipWhitelistMaxSize() {
        return ipWhitelistMaxSize;
    }

    public T ipWhitelistMaxSize(final int ipWhitelistMaxSize) {
        this.ipWhitelistMaxSize = ipWhitelistMaxSize;
        return self();
    }

    @Override
    public PgClientConfigBuilder pgClientConfig() {
        return pgClientConfig;
    }

    public T pgClientConfig(final PgClientConfig pgClientConfig) {
        this.pgClientConfig = new PgClientConfigBuilder(pgClientConfig);
        return self();
    }

    @Override
    public LoggerConfigBuilder tskvLoggerConfig() {
        return tskvLoggerConfig;
    }

    public T tskvLoggerConfig(final LoggerConfig tskvLoggerConfig) {
        this.tskvLoggerConfig = new LoggerConfigBuilder(tskvLoggerConfig);
        return self();
    }
}
