package ru.yandex.mail.so.cretur.config;

import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigBuilder;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.PositiveValidator;

public interface CreturConfig extends HttpProxyConfig {
    ParameterConfig<Integer> IP_WHITELIST_MAX_SIZE =
        new ParameterConfig<>(
            "cretur.ip-whitelist-max-size",
            Integer::valueOf,
            PositiveValidator.instance());

    SectionConfig<
        PgClientConfig,
        ImmutablePgClientConfig,
        PgClientConfigBuilder>
        PG_CLIENT = new SectionConfig<>(
            "pg-client",
            PgClientConfigBuilder::new,
            ImmutablePgClientConfig::new);

    SectionConfig<
        LoggerConfig,
        ImmutableLoggerConfig,
        LoggerConfigBuilder>
        TSKV_LOGGER_CONFIG = new SectionConfig<>(
            "tskvlog",
            LoggerConfigBuilder::new,
            ImmutableLoggerConfig::new);

    int ipWhitelistMaxSize();

    PgClientConfig pgClientConfig();

    LoggerConfig tskvLoggerConfig();
}
