package ru.yandex.mail.so.cretur.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class CreturConfigBuilder
    extends AbstractCreturConfigBuilder<CreturConfigBuilder>
{
    public CreturConfigBuilder() {
        super(CreturConfigDefaults.INSTANCE);
    }

    public CreturConfigBuilder(final CreturConfig config) {
        super(config);
    }

    public CreturConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, CreturConfigDefaults.INSTANCE);
    }

    public CreturConfigBuilder(
        final IniConfig config,
        final CreturConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public CreturConfigBuilder self() {
        return this;
    }

    public ImmutableCreturConfig build() throws ConfigException {
        return new ImmutableCreturConfig(this);
    }
}

