package ru.yandex.mail.so.cretur.config;

import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableCreturConfig
    extends ImmutableHttpProxyConfig
    implements CreturConfig
{
    private final int ipWhitelistMaxSize;
    private final ImmutablePgClientConfig pgClientConfig;
    private final ImmutableLoggerConfig tskvLoggerConfig;

    public ImmutableCreturConfig(final CreturConfig config)
        throws ConfigException
    {
        super(config);
        ipWhitelistMaxSize =
            IP_WHITELIST_MAX_SIZE.validate(config.ipWhitelistMaxSize());
        pgClientConfig = PG_CLIENT.validate(config.pgClientConfig());
        tskvLoggerConfig =
            TSKV_LOGGER_CONFIG.validate(config.tskvLoggerConfig());
    }

    @Override
    public int ipWhitelistMaxSize() {
        return ipWhitelistMaxSize;
    }

    @Override
    public ImmutablePgClientConfig pgClientConfig() {
        return pgClientConfig;
    }

    @Override
    public ImmutableLoggerConfig tskvLoggerConfig() {
        return tskvLoggerConfig;
    }
}

