package ru.yandex.mail.so.cwacf;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractCwacfConfigBuilder
    <T extends AbstractCwacfConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements CwacfConfig
{
    private HttpHostConfigBuilder upstreamConfig;

    protected AbstractCwacfConfigBuilder(final CwacfConfig config) {
        super(config);
        upstreamConfig(config.upstreamConfig());
    }

    protected AbstractCwacfConfigBuilder(
        final IniConfig config,
        final CwacfConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        upstreamConfig = new HttpHostConfigBuilder(
            config.section("upstream"),
            defaults.upstreamConfig());
    }

    @Override
    public HttpHostConfigBuilder upstreamConfig() {
        return upstreamConfig;
    }

    public T upstreamConfig(final HttpHostConfig upstreamConfig) {
        this.upstreamConfig = new HttpHostConfigBuilder(upstreamConfig);
        return self();
    }
}

