package ru.yandex.mail.so.cwacf;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class CwacfConfigBuilder
    extends AbstractCwacfConfigBuilder<CwacfConfigBuilder>
{
    public CwacfConfigBuilder() {
        super(CwacfConfigDefaults.INSTANCE);
    }

    public CwacfConfigBuilder(final CwacfConfig config) {
        super(config);
    }

    public CwacfConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, CwacfConfigDefaults.INSTANCE);
    }

    public CwacfConfigBuilder(
        final IniConfig config,
        final CwacfConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public CwacfConfigBuilder self() {
        return this;
    }

    public ImmutableCwacfConfig build() throws ConfigException {
        return new ImmutableCwacfConfig(this);
    }
}

