package ru.yandex.mail.so.cwacf;

import java.io.IOException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.rpc.JsonRpcErrorCode;
import ru.yandex.json.rpc.JsonRpcException;
import ru.yandex.json.rpc.JsonRpcRequest;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;

public class CwacfRequestContext {
    private final Cwacf cwacf;
    private final ProxySession session;
    private final JsonRpcRequest request;
    private final JsonType jsonType;
    private final String key;
    private final String type;
    private final String query;
    private final String body;

    public CwacfRequestContext(
        final Cwacf cwacf,
        final ProxySession session,
        final JsonRpcRequest request)
        throws BadRequestException, JsonRpcException
    {
        this.cwacf = cwacf;
        this.session = session;
        this.request = request;
        QueryConstructor query =
            new QueryConstructor("/check-json?service=GEOCHATS");
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = new JsonWriter(sbw)) {
            jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
            JsonMap params = request.params().asMap();
            key = params.getString("key");
            type = params.getString("type");
            JsonMap body = params.get("body").asMap();
            String service = params.getString("service");
            String chatId = body.getString("ChatId", service);
            Long uid = body.getLong("Uid", null);
            if (uid != null) {
                query.append("so_login", uid.longValue());
            }
            query.append("form_id", chatId);
            query.append("id", key);
            query.append(
                "reqid",
                (String) session.context().getAttribute(
                    HttpServer.SESSION_ID));

            writer.startObject();
            writer.key("client_ip");
            writer.value(body.getString("UserIp", ""));
            writer.key("client_uid");
            writer.value(uid);
            writer.key("form_id");
            writer.value(chatId);
            writer.key("form_type");
            writer.value(service);
            String message = body.getString("Message", "");
            String chatName = body.getString("ChatName", "");

            writer.key("form_fields");
            writer.startObject();
            writer.key("chat_name");
            writer.startObject();
            writer.key("type");
            writer.value("string");
            writer.key("filled_by");
            writer.value("user");
            writer.key("value");
            writer.value(chatName);
            writer.endObject();

            writer.key("message");
            writer.startObject();
            writer.key("type");
            writer.value("string");
            writer.key("filled_by");
            writer.value("user");
            writer.key("value");
            writer.value(message);
            writer.endObject();

            String guid = body.getString("Guid", null);
            if (guid != null) {
                writer.key("guid");
                writer.startObject();
                writer.key("type");
                writer.value("string");
                writer.key("filled_by");
                writer.value("automatic");
                writer.key("value");
                writer.value(guid);
                writer.endObject();
            }

            String isRobot = body.getString("IsRobot", null);
            if (isRobot != null) {
                writer.key("is_robot");
                writer.startObject();
                writer.key("type");
                writer.value("string");
                writer.key("filled_by");
                writer.value("automatic");
                writer.key("value");
                writer.value(isRobot);
                writer.endObject();
            }

            String chatType = body.getString("ChatType", null);
            if (chatType!= null) {
                writer.key("chat_type");
                writer.startObject();
                writer.key("type");
                writer.value("string");
                writer.key("filled_by");
                writer.value("automatic");
                writer.key("value");
                writer.value(chatType);
                writer.endObject();
            }

            String chatCreationTs = body.getString("ChatCreationTs", null);
            if (chatCreationTs != null) {
                writer.key("chat_creation_timestamp");
                writer.startObject();
                writer.key("type");
                writer.value("string");
                writer.key("filled_by");
                writer.value("automatic");
                writer.key("value");
                writer.value(chatCreationTs);
                writer.endObject();
            }

            String timestamp = body.getString("Timestamp", null);
            if (timestamp != null) {
                writer.key("message_timestamp");
                writer.startObject();
                writer.key("type");
                writer.value("string");
                writer.key("filled_by");
                writer.value("automatic");
                writer.key("value");
                writer.value(timestamp);
                writer.endObject();
            }

            String yandexUid = body.getString("YandexUid", null);
            if (yandexUid != null) {
                writer.key("yandex_uid");
                writer.startObject();
                writer.key("type");
                writer.value("string");
                writer.key("filled_by");
                writer.value("automatic");
                writer.key("value");
                writer.value(yandexUid);
                writer.endObject();
            }

            writer.endObject();

            writer.key("subject_template");
            writer.value("{chat_name}");
            writer.key("subject");
            writer.value(chatName);
            writer.key("body_template");
            writer.value("{message}");
            writer.key("body");
            writer.value(message);

            writer.endObject();
        } catch (JsonException e) {
            throw new JsonRpcException(
                JsonRpcErrorCode.INVALID_PARAMS,
                "Failed to extract params",
                request.params(),
                e);
        } catch (IOException e) {
            throw new BadRequestException(
                "Failed to rewrite request: "
                + JsonType.HUMAN_READABLE.toString(request),
                e);
        }

        this.query = query.toString();
        this.body = sbw.toString();
    }

    public Cwacf cwacf() {
        return cwacf;
    }

    public ProxySession session() {
        return session;
    }

    public JsonRpcRequest request() {
        return request;
    }

    public JsonType jsonType() {
        return jsonType;
    }

    public String key() {
        return key;
    }

    public String type() {
        return type;
    }

    public String query() {
        return query;
    }

    public String body() {
        return body;
    }
}

