package ru.yandex.mail.so.cwacf;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableCwacfConfig
    extends ImmutableHttpProxyConfig
    implements CwacfConfig
{
    private final ImmutableHttpHostConfig upstreamConfig;

    public ImmutableCwacfConfig(final CwacfConfig config)
        throws ConfigException
    {
        super(config);
        upstreamConfig = new ImmutableHttpHostConfig(config.upstreamConfig());
    }

    @Override
    public ImmutableHttpHostConfig upstreamConfig() {
        return upstreamConfig;
    }
}

