package ru.yandex.mail.so.jrbld;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.json.writer.JsonWriter;

public abstract class AbstractCheckIpHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected final Jrbld jrbld;
    protected final Map<String, IpInfoProvider> infoProviders;
    protected final Map<String, AsyncIpChecker> checkers;

    protected AbstractCheckIpHandler(
        final Jrbld jrbld,
        final Map<String, IpInfoProvider> infoProviders,
        final Map<String, AsyncIpChecker> checkers)
    {
        this.jrbld = jrbld;
        this.infoProviders = infoProviders;
        this.checkers = checkers;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    // CSOFF: ParameterNumber
    public static void writeResult(
        final JsonWriter writer,
        final List<NamedInfo> infoResults,
        final List<NamedCheckResult> checkResults,
        final boolean getValues)
        throws IOException
    {
        writer.startObject();

        writer.key("infos");
        writer.startObject();
        for (NamedInfo namedInfo: infoResults) {
            writer.key(namedInfo.name());
            writer.jsonValue(namedInfo.info());
        }
        writer.endObject();

        writer.key("checks");
        writer.startObject();
        for (NamedCheckResult namedCheckResult: checkResults) {
            writer.key(namedCheckResult.name());
            Integer checkResult = namedCheckResult.checkResult();
            if (checkResult == null) {
                writer.nullValue();
            } else if (getValues) {
                writer.value(checkResult);
            } else {
                writer.value(checkResult.intValue() != 0);
            }
        }
        writer.endObject();

        writer.endObject();
    }
    // CSON: ParameterNumber

    public static class NamedInfo {
        private final String name;
        private final String info;

        NamedInfo(final String name, final String info) {
            this.name = name;
            this.info = info;
        }

        public String name() {
            return name;
        }

        public String info() {
            return info;
        }
    }

    public static class NamedCheckResult {
        private final String name;
        private final Integer checkResult;

        NamedCheckResult(final String name, final Integer checkResult) {
            this.name = name;
            this.checkResult = checkResult;
        }

        public String name() {
            return name;
        }

        public Integer checkResult() {
            return checkResult;
        }
    }

    public static class NamedInfoCallback
        extends AbstractFilterFutureCallback<String, NamedInfo>
    {
        private final String name;
        private final Logger logger;

        NamedInfoCallback(
            final FutureCallback<NamedInfo> callback,
            final String name,
            final Logger logger)
        {
            super(callback);
            this.name = name;
            this.logger = logger;
        }

        @Override
        public void completed(final String result) {
            callback.completed(new NamedInfo(name, result));
        }

        @Override
        public void failed(final Exception e) {
            logger.log(
                Level.WARNING,
                "Failed to extract info for '" + name + '\'',
                e);
            callback.completed(new NamedInfo(name, null));
        }
    }

    public static class NamedCheckResultCallback
        extends AbstractFilterFutureCallback<Integer, NamedCheckResult>
    {
        private final String name;
        private final Logger logger;

        NamedCheckResultCallback(
            final FutureCallback<NamedCheckResult> callback,
            final String name,
            final Logger logger)
        {
            super(callback);
            this.name = name;
            this.logger = logger;
        }

        @Override
        public void completed(final Integer result) {
            callback.completed(new NamedCheckResult(name, result));
        }

        @Override
        public void failed(final Exception e) {
            logger.log(
                Level.WARNING,
                "Failed to extract checkResult for '" + name + '\'',
                e);
            callback.completed(new NamedCheckResult(name, null));
        }
    }
}

