package ru.yandex.mail.so.jrbld;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.http.util.FixedMultiFutureCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.CgiParams;

public class CheckIpHandler extends AbstractCheckIpHandler {
    public CheckIpHandler(
        final Jrbld jrbld,
        final Map<String, IpInfoProvider> infoProviders,
        final Map<String, AsyncIpChecker> checkers)
    {
        super(jrbld, infoProviders, checkers);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(jrbld, exchange, context);
        Logger logger = session.logger();

        IpCheckContext checkContext =
            new IpCheckContext(session, infoProviders, checkers);
        Map<String, IpInfoProvider> infos = checkContext.infos();
        Map<String, AsyncIpChecker> checks = checkContext.checks();

        IpCheckRequest ipCheckRequest = new IpCheckRequest(
            session.params().get("ip", InetAddress::getByName),
            session);
        DoubleFutureCallback<List<NamedInfo>, List<NamedCheckResult>>
            callback = new DoubleFutureCallback<>(new Callback(session));

        FixedMultiFutureCallback<NamedInfo> infosCallback =
            new FixedMultiFutureCallback<>(callback.first(), infos.size());
        int i = 0;
        for (Map.Entry<String, IpInfoProvider> entry: infos.entrySet()) {
            entry.getValue().info(
                ipCheckRequest,
                new NamedInfoCallback(
                    infosCallback.callback(i++),
                    entry.getKey(),
                    logger));
        }

        FixedMultiFutureCallback<NamedCheckResult> checksCallback =
            new FixedMultiFutureCallback<>(callback.second(), checks.size());
        i = 0;
        for (Map.Entry<String, AsyncIpChecker> entry: checks.entrySet()) {
            entry.getValue().check(
                ipCheckRequest,
                new NamedCheckResultCallback(
                    checksCallback.callback(i++),
                    entry.getKey(),
                    logger));
        }
    }

    private static class Callback
        extends AbstractProxySessionCallback<
            Map.Entry<List<NamedInfo>, List<NamedCheckResult>>>
    {
        private final JsonType jsonType;
        private final boolean getValues;

        Callback(final ProxySession session) throws BadRequestException {
            super(session);
            CgiParams params = session.params();
            jsonType = JsonTypeExtractor.NORMAL.extract(params);
            getValues = params.getBoolean("get-values", false);
        }

        @Override
        public void completed(
            final Map.Entry<List<NamedInfo>, List<NamedCheckResult>> result)
        {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter writer = jsonType.create(sbw)) {
                writeResult(
                    writer,
                    result.getKey(),
                    result.getValue(),
                    getValues);
            } catch (IOException e) {
                failed(e);
                return;
            }
            session.response(
                HttpStatus.SC_OK,
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset())));
        }
    }
}

