package ru.yandex.mail.so.jrbld;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.http.util.FixedMultiFutureCallback;
import ru.yandex.http.util.PayloadFutureCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.CgiParams;

public class CheckIpsHandler extends AbstractCheckIpHandler {
    public CheckIpsHandler(
        final Jrbld jrbld,
        final Map<String, IpInfoProvider> infoProviders,
        final Map<String, AsyncIpChecker> checkers)
    {
        super(jrbld, infoProviders, checkers);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(jrbld, exchange, context);
        CgiParams params = session.params();
        Logger logger = session.logger();

        IpCheckContext checkContext =
            new IpCheckContext(session, infoProviders, checkers);
        Map<String, IpInfoProvider> infos = checkContext.infos();
        Map<String, AsyncIpChecker> checks = checkContext.checks();

        List<String> ips = params.getAll("ip");
        FixedMultiFutureCallback<
            Map.Entry<
                String,
                Map.Entry<List<NamedInfo>, List<NamedCheckResult>>>> callback =
                    new FixedMultiFutureCallback<>(
                        new Callback(session),
                        ips.size());
        int i = 0;
        for (String ip: ips) {
            DoubleFutureCallback<List<NamedInfo>, List<NamedCheckResult>>
                ipCallback =
                    new DoubleFutureCallback<>(
                        new PayloadFutureCallback<>(
                            ip,
                            callback.callback(i++)));
            InetAddress address;
            try {
                address = InetAddress.getByName(ip);
            } catch (UnknownHostException e) {
                throw new BadRequestException("Malformed ip: " + ip, e);
            }
            IpCheckRequest ipCheckRequest =
                new IpCheckRequest(address, session);

            FixedMultiFutureCallback<NamedInfo> infosCallback =
                new FixedMultiFutureCallback<>(
                    ipCallback.first(),
                    infos.size());
            int j = 0;
            for (Map.Entry<String, IpInfoProvider> entry: infos.entrySet()) {
                entry.getValue().info(
                    ipCheckRequest,
                    new NamedInfoCallback(
                        infosCallback.callback(j++),
                        entry.getKey(),
                        logger));
            }

            FixedMultiFutureCallback<NamedCheckResult> checksCallback =
                new FixedMultiFutureCallback<>(
                    ipCallback.second(),
                    checks.size());
            j = 0;
            for (Map.Entry<String, AsyncIpChecker> entry: checks.entrySet()) {
                entry.getValue().check(
                    ipCheckRequest,
                    new NamedCheckResultCallback(
                        checksCallback.callback(j++),
                        entry.getKey(),
                        logger));
            }
        }
    }

    private static class Callback
        extends AbstractProxySessionCallback<
            List<
                Map.Entry<
                    String,
                    Map.Entry<List<NamedInfo>, List<NamedCheckResult>>>>>
    {
        private final JsonType jsonType;
        private final boolean getValues;

        Callback(final ProxySession session) throws BadRequestException {
            super(session);
            CgiParams params = session.params();
            jsonType = JsonTypeExtractor.NORMAL.extract(params);
            getValues = params.getBoolean("get-values", false);
        }

        @Override
        public void completed(
            final List<
                Map.Entry<
                    String,
                    Map.Entry<List<NamedInfo>, List<NamedCheckResult>>>> data)
        {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter writer = jsonType.create(sbw)) {
                writer.startObject();
                for (Map.Entry<
                    String,
                    Map.Entry<List<NamedInfo>, List<NamedCheckResult>>> ipRes
                    : data)
                {
                    writer.key(ipRes.getKey());
                    Map.Entry<List<NamedInfo>, List<NamedCheckResult>> result =
                        ipRes.getValue();
                    writeResult(
                        writer,
                        result.getKey(),
                        result.getValue(),
                        getValues);
                }
                writer.endObject();
            } catch (IOException e) {
                failed(e);
                return;
            }
            session.response(
                HttpStatus.SC_OK,
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON.withCharset(
                        session.acceptedCharset())));
        }
    }
}

