package ru.yandex.mail.so.jrbld;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.CgiParams;

public class IpCheckContext {
    private final ProxySession session;
    private final Map<String, IpInfoProvider> infos;
    private final Map<String, AsyncIpChecker> checks;

    public IpCheckContext(
        final ProxySession session,
        final Map<String, IpInfoProvider> infoProviders,
        final Map<String, AsyncIpChecker> checkers)
        throws BadRequestException
    {
        this.session = session;

        CgiParams params = session.params();

        infos = parse(params.getAll("info"), infoProviders, "info provider");
        checks = parse(params.getAll("check"), checkers, "checker");
    }

    public ProxySession session() {
        return session;
    }

    public Map<String, IpInfoProvider> infos() {
        return infos;
    }

    public Map<String, AsyncIpChecker> checks() {
        return checks;
    }

    private static <T> Map<String, T> parse(
        final List<String> names,
        final Map<String, T> sources,
        final String sourceType)
        throws BadRequestException
    {
        Map<String, T> result;
        int size = names.size();
        switch (size) {
            case 0:
                result = Collections.emptyMap();
                break;
            case 1:
                String sourceName = names.get(0);
                result = Collections.singletonMap(
                    sourceName,
                    parseSource(sourceName, sources, sourceType));
                break;
            default:
                result = new LinkedHashMap<>(size << 1);
                for (String name: names) {
                    result.put(name, parseSource(name, sources, sourceType));
                }
                break;
        }
        return result;
    }

    private static <T> T parseSource(
        final String name,
        final Map<String, T> sources,
        final String sourceType)
        throws BadRequestException
    {
        T result = sources.get(name);
        if (result == null) {
            throw new BadRequestException(
                "Unknown " + sourceType + ' ' + '"' + name + '"');
        } else {
            return result;
        }
    }
}

