package ru.yandex.mail.so.jrbld;

import java.net.InetAddress;

import org.apache.http.concurrent.Cancellable;

import ru.yandex.http.proxy.ProxySession;

public class IpCheckRequest implements Cancellable {
    private final InetAddress ip;
    private final ProxySession session;
    private final String ipString;
    private volatile boolean cancelled = false;

    public IpCheckRequest(final InetAddress ip, final ProxySession session) {
        this.ip = ip;
        this.session = session;
        ipString = ip.getHostAddress().toString();
        session.subscribeForCancellation(this);
    }

    public InetAddress ip() {
        return ip;
    }

    public String ipString() {
        return ipString;
    }

    public ProxySession session() {
        return session;
    }

    @Override
    public boolean cancel() {
        cancelled = true;
        return true;
    }

    public boolean cancelled() {
        return cancelled;
    }
}

