package ru.yandex.mail.so.jrbld;

import java.io.IOException;
import java.net.InetAddress;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.util.ip.ReloadableIpChecker;

public class IpSetCheckerAdapter
    implements ReloadableAsyncIpChecker, ReloadableIpChecker
{
    private final Integer value;
    private final ReloadableIpChecker checker;

    public IpSetCheckerAdapter(
        final int value,
        final ReloadableIpChecker checker)
    {
        this.value = value;
        this.checker = checker;
    }

    public Integer value() {
        return value;
    }

    @Override
    public void reload() throws IOException {
        checker.reload();
    }

    @Override
    public boolean test(final InetAddress ip) {
        return checker.test(ip);
    }

    @Override
    public void check(
        final IpCheckRequest request,
        final FutureCallback<? super Integer> callback)
    {
        Integer result;
        if (checker.test(request.ip())) {
            result = value;
        } else {
            result = ZERO;
        }
        callback.completed(result);
    }

    @Override
    public String toString() {
        return checker.toString();
    }
}

