package ru.yandex.mail.so.jrbld;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperException;

public class JniIpInfoProvider implements IpInfoProvider {
    private final JniWrapper jniwrapper;

    public JniIpInfoProvider(final JniWrapper jniwrapper) {
        this.jniwrapper = jniwrapper;
    }

    private String info(final String addr) throws HttpException {
        try {
            return jniwrapper.apply(addr, null).process(null, 0, 0);
        } catch (JniWrapperException e) {
            throw new ServiceUnavailableException(
                "Failed to resolve address <" + addr + '>',
                e);
        }
    }

    @Override
    public void info(
        final IpCheckRequest request,
        final FutureCallback<String> callback)
    {
        try {
            callback.completed(info(request.ipString()));
        } catch (HttpException e) {
            callback.failed(e);
        }
    }
}

