package ru.yandex.mail.so.jrbld;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.server.HttpServer;

public class ReloadListsHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final List<ReloadableAsyncIpChecker> checkers;

    public ReloadListsHandler(final List<ReloadableAsyncIpChecker> checkers) {
        this.checkers = checkers;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        Logger logger = (Logger) context.getAttribute(HttpServer.LOGGER);
        try {
            for (ReloadableAsyncIpChecker checker: checkers) {
                logger.fine("Reloading checker: " + checker);
                checker.reload();
            }
        } catch (IOException e) {
            logger.log(Level.WARNING, "IP lists reload failed", e);
            throw new ServiceUnavailableException(e);
        }
        logger.info("IP lists reload completed");
        exchange.getResponse().setEntity(
            new NStringEntity("IP lists reloaded", ContentType.TEXT_PLAIN));
        exchange.submitResponse();
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public String toString() {
        return "Reloads IP lists from files";
    }
}
