package ru.yandex.mail.so.jrbld;

import java.util.function.Consumer;

import org.apache.http.concurrent.FutureCallback;

public class StatingIpChecker implements AsyncIpChecker {
    private final AsyncIpChecker checker;
    private final Consumer<Object> resultConsumer;

    public StatingIpChecker(
        final AsyncIpChecker checker,
        final Consumer<Object> resultConsumer)
    {
        this.checker = checker;
        this.resultConsumer = resultConsumer;
    }

    @Override
    public String toString() {
        return checker.toString();
    }

    @Override
    public void check(
        final IpCheckRequest request,
        final FutureCallback<? super Integer> callback)
    {
        checker.check(
            request,
            new StatingCallback(callback, resultConsumer));
    }

    private static class StatingCallback implements FutureCallback<Integer> {
        private static final Object NULL_REPLACEMENT = new Object();

        private final FutureCallback<? super Integer> callback;
        private final Consumer<Object> resultConsumer;

        StatingCallback(
            final FutureCallback<? super Integer> callback,
            final Consumer<Object> resultConsumer)
        {
            this.callback = callback;
            this.resultConsumer = resultConsumer;
        }

        @Override
        public void cancelled() {
            resultConsumer.accept(NULL_REPLACEMENT);
            callback.cancelled();
        }

        @Override
        public void completed(final Integer result) {
            Object nextValue;
            if (result == null) {
                nextValue = NULL_REPLACEMENT;
            } else if (result.intValue() == 0) {
                nextValue = Boolean.FALSE;
            } else {
                nextValue = Boolean.TRUE;
            }
            resultConsumer.accept(nextValue);
            callback.completed(result);
        }

        @Override
        public void failed(final Exception e) {
            resultConsumer.accept(NULL_REPLACEMENT);
            callback.failed(e);
        }
    }
}

