package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.util.ip.AbstractCidrListConfigBuilder;

public abstract class AbstractCidrListSourceConfigBuilder
    <T extends AbstractCidrListSourceConfigBuilder<T>>
    extends AbstractCidrListConfigBuilder<T>
    implements CidrListSourceConfig
{
    private int value;

    protected AbstractCidrListSourceConfigBuilder(
        final CidrListSourceConfig config)
    {
        super(config);
        value(config.value());
    }

    protected AbstractCidrListSourceConfigBuilder(
        final IniConfig config,
        final CidrListSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        value = JrbldConfig.VALUE.extract(config, defaults.value());
    }

    @Override
    public int value() {
        return value;
    }

    public T value(final int value) {
        this.value = value;
        return self();
    }
}

